/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.wrapper.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.events.CollectionAccessEvent;
import org.apache.isis.applib.events.InteractionEvent;
import org.apache.isis.applib.events.ObjectTitleEvent;
import org.apache.isis.applib.events.PropertyAccessEvent;
import org.apache.isis.applib.events.UsabilityEvent;
import org.apache.isis.applib.events.ValidityEvent;
import org.apache.isis.applib.events.VisibilityEvent;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.services.wrapper.DisabledException;
import org.apache.isis.applib.services.wrapper.HiddenException;
import org.apache.isis.applib.services.wrapper.InteractionException;
import org.apache.isis.applib.services.wrapper.InvalidException;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.applib.services.wrapper.WrapperObject;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectPersistor;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.util.AdapterUtils;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInvocationMethod;
import org.apache.isis.core.metamodel.consent.InteractionResult;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.actions.choices.ActionChoicesFacet;
import org.apache.isis.core.metamodel.facets.actions.defaults.ActionDefaultsFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionAddToFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionRemoveFromFacet;
import org.apache.isis.core.metamodel.facets.param.choices.ActionParameterChoicesFacet;
import org.apache.isis.core.metamodel.facets.properties.choices.PropertyChoicesFacet;
import org.apache.isis.core.metamodel.facets.properties.defaults.PropertyDefaultFacet;
import org.apache.isis.core.metamodel.facets.properties.modify.PropertyInitializationFacet;
import org.apache.isis.core.metamodel.facets.properties.modify.PropertySetterFacet;
import org.apache.isis.core.metamodel.interactions.ObjectTitleContext;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.metamodel.specloader.specimpl.dflt.ObjectSpecificationDefault;
import org.apache.isis.core.progmodel.facets.actions.validate.method.ActionValidationFacetViaMethod;
import org.apache.isis.core.progmodel.facets.collections.validate.CollectionValidateAddToFacetViaMethod;
import org.apache.isis.core.progmodel.facets.collections.validate.CollectionValidateRemoveFromFacetViaMethod;
import org.apache.isis.core.progmodel.facets.members.disabled.method.DisableForContextFacetViaMethod;
import org.apache.isis.core.progmodel.facets.members.hidden.method.HideForContextFacetViaMethod;
import org.apache.isis.core.progmodel.facets.properties.modify.PropertyClearFacetViaClearMethod;
import org.apache.isis.core.progmodel.facets.properties.modify.PropertySetterFacetViaModifyMethod;
import org.apache.isis.core.progmodel.facets.properties.validate.PropertyValidateFacetViaMethod;
import org.apache.isis.core.wrapper.internal.DelegatingInvocationHandlerDefault;
import org.apache.isis.core.wrapper.internal.Proxy;

public class DomainObjectInvocationHandler<T>
extends DelegatingInvocationHandlerDefault<T> {
    private final Map<Method, Collection<?>> collectionViewObjectsByMethod = new HashMap();
    private final Map<Method, Map<?, ?>> mapViewObjectsByMethod = new HashMap();
    private final AuthenticationSessionProvider authenticationSessionProvider;
    private final SpecificationLoader specificationLookup;
    private final AdapterManager adapterManager;
    private final ObjectPersistor objectPersistor;
    protected Method titleMethod;
    protected Method saveMethod;
    protected Method wrappedMethod;
    private final Where where = Where.ANYWHERE;

    public DomainObjectInvocationHandler(T delegate, WrapperFactory embeddedViewer, WrapperFactory.ExecutionMode mode, AuthenticationSessionProvider authenticationSessionProvider, SpecificationLoader specificationLookup, AdapterManager adapterManager, ObjectPersistor objectPersistor) {
        super(delegate, embeddedViewer, mode);
        this.authenticationSessionProvider = authenticationSessionProvider;
        this.specificationLookup = specificationLookup;
        this.adapterManager = adapterManager;
        this.objectPersistor = objectPersistor;
        try {
            this.titleMethod = delegate.getClass().getMethod("title", new Class[0]);
            this.saveMethod = WrapperObject.class.getMethod("save", new Class[0]);
            this.wrappedMethod = WrapperObject.class.getMethod("wrapped", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
    }

    @Override
    public Object invoke(Object proxyObject, Method method, Object[] args) throws Throwable {
        if (this.isObjectMethod(method)) {
            return this.delegate(method, args);
        }
        if (this.isJdoMethod(method)) {
            return this.delegate(method, args);
        }
        if (this.isInjectMethod(method)) {
            return this.delegate(method, args);
        }
        ObjectAdapter targetAdapter = this.getAdapterManager().getAdapterFor(this.getDelegate());
        if (this.isTitleMethod(method)) {
            return this.handleTitleMethod(method, args, targetAdapter);
        }
        ObjectSpecification targetNoSpec = targetAdapter.getSpecification();
        if (this.isSaveMethod(method)) {
            return this.handleSaveMethod(this.getAuthenticationSession(), targetAdapter, targetNoSpec);
        }
        if (this.isUnderlyingMethod(method)) {
            return this.getDelegate();
        }
        ObjectMember objectMember = this.locateAndCheckMember(method);
        List<Facet> imperativeFacets = this.getImperativeFacets(objectMember, method);
        String memberName = objectMember.getName();
        if (DomainObjectInvocationHandler.instanceOf(imperativeFacets, DisableForContextFacetViaMethod.class, HideForContextFacetViaMethod.class)) {
            throw new UnsupportedOperationException(String.format("Cannot invoke supporting method '%s'", memberName));
        }
        String methodName = method.getName();
        if (DomainObjectInvocationHandler.instanceOf(imperativeFacets, ActionDefaultsFacet.class, PropertyDefaultFacet.class, ActionChoicesFacet.class, ActionParameterChoicesFacet.class, PropertyChoicesFacet.class)) {
            return method.invoke(this.getDelegate(), args);
        }
        this.checkVisibility(this.getAuthenticationSession(), targetAdapter, objectMember);
        if (objectMember.isOneToOneAssociation()) {
            if (DomainObjectInvocationHandler.instanceOf(imperativeFacets, PropertyValidateFacetViaMethod.class, PropertySetterFacetViaModifyMethod.class, PropertyClearFacetViaClearMethod.class)) {
                throw new UnsupportedOperationException(String.format("Cannot invoke supporting method '%s'; use only property accessor/mutator", memberName));
            }
            OneToOneAssociation otoa = (OneToOneAssociation)objectMember;
            if (DomainObjectInvocationHandler.instanceOf(imperativeFacets, PropertyOrCollectionAccessorFacet.class)) {
                return this.handleGetterMethodOnProperty(args, targetAdapter, otoa, methodName);
            }
            if (DomainObjectInvocationHandler.instanceOf(imperativeFacets, PropertySetterFacet.class, PropertyInitializationFacet.class)) {
                this.checkUsability(this.getAuthenticationSession(), targetAdapter, objectMember);
                return this.handleSetterMethodOnProperty(args, this.getAuthenticationSession(), targetAdapter, otoa, methodName);
            }
        }
        if (objectMember.isOneToManyAssociation()) {
            if (DomainObjectInvocationHandler.instanceOf(imperativeFacets, CollectionValidateAddToFacetViaMethod.class, CollectionValidateRemoveFromFacetViaMethod.class)) {
                throw new UnsupportedOperationException(String.format("Cannot invoke supporting method '%s'; use only collection accessor/mutator", memberName));
            }
            OneToManyAssociation otma = (OneToManyAssociation)objectMember;
            if (DomainObjectInvocationHandler.instanceOf(imperativeFacets, PropertyOrCollectionAccessorFacet.class)) {
                return this.handleGetterMethodOnCollection(method, args, targetAdapter, otma, memberName);
            }
            if (DomainObjectInvocationHandler.instanceOf(imperativeFacets, CollectionAddToFacet.class)) {
                this.checkUsability(this.getAuthenticationSession(), targetAdapter, objectMember);
                return this.handleCollectionAddToMethod(args, targetAdapter, otma, methodName);
            }
            if (DomainObjectInvocationHandler.instanceOf(imperativeFacets, CollectionRemoveFromFacet.class)) {
                this.checkUsability(this.getAuthenticationSession(), targetAdapter, objectMember);
                return this.handleCollectionRemoveFromMethod(args, targetAdapter, otma, methodName);
            }
        }
        if (DomainObjectInvocationHandler.instanceOf(imperativeFacets, PropertyOrCollectionAccessorFacet.class)) {
            throw new UnsupportedOperationException(String.format("Can only invoke accessor on properties or collections; '%s' represents %s", methodName, this.decode(objectMember)));
        }
        if (DomainObjectInvocationHandler.instanceOf(imperativeFacets, PropertySetterFacet.class)) {
            throw new UnsupportedOperationException(String.format("Can only invoke mutator on properties; '%s' represents %s", methodName, this.decode(objectMember)));
        }
        if (DomainObjectInvocationHandler.instanceOf(imperativeFacets, CollectionAddToFacet.class)) {
            throw new UnsupportedOperationException(String.format("Can only invoke 'adder' on collections; '%s' represents %s", methodName, this.decode(objectMember)));
        }
        if (DomainObjectInvocationHandler.instanceOf(imperativeFacets, CollectionRemoveFromFacet.class)) {
            throw new UnsupportedOperationException(String.format("Can only invoke 'remover' on collections; '%s' represents %s", methodName, this.decode(objectMember)));
        }
        if (objectMember instanceof ObjectAction) {
            if (DomainObjectInvocationHandler.instanceOf(imperativeFacets, ActionValidationFacetViaMethod.class)) {
                throw new UnsupportedOperationException(String.format("Cannot invoke supporting method '%s'; use only the 'invoke' method", memberName));
            }
            this.checkUsability(this.getAuthenticationSession(), targetAdapter, objectMember);
            ObjectAction noa = (ObjectAction)objectMember;
            return this.handleActionMethod(args, this.getAuthenticationSession(), targetAdapter, noa, memberName);
        }
        throw new UnsupportedOperationException(String.format("Unknown member type '%s'", objectMember));
    }

    private boolean isJdoMethod(Method method) {
        return this.methodStartsWith(method, "jdo");
    }

    private boolean isInjectMethod(Method method) {
        return this.methodStartsWith(method, "inject");
    }

    private boolean methodStartsWith(Method method, String prefix) {
        return method.getName().startsWith(prefix);
    }

    public List<Facet> getImperativeFacets(ObjectMember objectMember, final Method method) {
        List imperativeFacets = objectMember.getFacets((Filter)new Filter<Facet>(){

            public boolean accept(Facet facet) {
                ImperativeFacet imperativeFacet = this.asImperativeFacet(facet);
                if (imperativeFacet == null) {
                    return false;
                }
                return imperativeFacet.getMethods().contains(method);
            }

            private ImperativeFacet asImperativeFacet(Facet facet) {
                if (facet == null) {
                    return null;
                }
                if (facet instanceof ImperativeFacet) {
                    return (ImperativeFacet)facet;
                }
                return this.asImperativeFacet(facet.getUnderlyingFacet());
            }
        });
        if (imperativeFacets.isEmpty()) {
            throw new IllegalStateException("should be at least one imperative facet");
        }
        return imperativeFacets;
    }

    private static boolean instanceOf(List<?> objects, Class<?> ... superTypes) {
        for (Class<?> superType : superTypes) {
            for (Object obj : objects) {
                if (!superType.isAssignableFrom(obj.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    private Object handleTitleMethod(Method method, Object[] args, ObjectAdapter targetAdapter) throws IllegalAccessException, InvocationTargetException {
        this.resolveIfRequired(targetAdapter);
        ObjectSpecification targetNoSpec = targetAdapter.getSpecification();
        ObjectTitleContext titleContext = targetNoSpec.createTitleInteractionContext(this.getAuthenticationSession(), InteractionInvocationMethod.BY_USER, targetAdapter);
        ObjectTitleEvent titleEvent = titleContext.createInteractionEvent();
        this.notifyListeners((InteractionEvent)titleEvent);
        return titleEvent.getTitle();
    }

    private Object handleSaveMethod(AuthenticationSession session, ObjectAdapter targetAdapter, ObjectSpecification targetNoSpec) {
        InteractionResult interactionResult = targetNoSpec.isValidResult(targetAdapter);
        this.notifyListenersAndVetoIfRequired(interactionResult);
        if (this.getExecutionMode() == WrapperFactory.ExecutionMode.EXECUTE && targetAdapter.isTransient()) {
            this.getObjectPersistor().makePersistent(targetAdapter);
        }
        return null;
    }

    private Object handleGetterMethodOnProperty(Object[] args, ObjectAdapter targetAdapter, OneToOneAssociation otoa, String methodName) {
        if (args.length != 0) {
            throw new IllegalArgumentException("Invoking a 'get' should have no arguments");
        }
        this.resolveIfRequired(targetAdapter);
        ObjectAdapter currentReferencedAdapter = otoa.get(targetAdapter);
        Object currentReferencedObj = AdapterUtils.unwrap((ObjectAdapter)currentReferencedAdapter);
        PropertyAccessEvent ev = new PropertyAccessEvent(this.getDelegate(), otoa.getIdentifier(), currentReferencedObj);
        this.notifyListeners((InteractionEvent)ev);
        return currentReferencedObj;
    }

    private Object handleSetterMethodOnProperty(Object[] args, AuthenticationSession session, ObjectAdapter targetAdapter, OneToOneAssociation otoa, String methodName) {
        if (args.length != 1) {
            throw new IllegalArgumentException("Invoking a setter should only have a single argument");
        }
        this.resolveIfRequired(targetAdapter);
        Object argumentObj = this.underlying(args[0]);
        ObjectAdapter argumentAdapter = argumentObj != null ? this.getAdapterManager().adapterFor(argumentObj) : null;
        InteractionResult interactionResult = otoa.isAssociationValid(targetAdapter, argumentAdapter).getInteractionResult();
        this.notifyListenersAndVetoIfRequired(interactionResult);
        if (this.getExecutionMode() == WrapperFactory.ExecutionMode.EXECUTE) {
            otoa.set(targetAdapter, argumentAdapter);
        }
        this.objectChangedIfRequired(targetAdapter);
        return null;
    }

    private Object handleGetterMethodOnCollection(Method method, Object[] args, ObjectAdapter targetAdapter, OneToManyAssociation otma, String memberName) {
        if (args.length != 0) {
            throw new IllegalArgumentException("Invoking a 'get' should have no arguments");
        }
        this.resolveIfRequired(targetAdapter);
        ObjectAdapter currentReferencedAdapter = otma.get(targetAdapter);
        Object currentReferencedObj = AdapterUtils.unwrap((ObjectAdapter)currentReferencedAdapter);
        CollectionAccessEvent ev = new CollectionAccessEvent(this.getDelegate(), otma.getIdentifier());
        if (currentReferencedObj instanceof Collection) {
            Collection<?> collectionViewObject = this.lookupViewObject(method, memberName, (Collection)currentReferencedObj, otma);
            this.notifyListeners((InteractionEvent)ev);
            return collectionViewObject;
        }
        if (currentReferencedObj instanceof Map) {
            Map<?, ?> mapViewObject = this.lookupViewObject(method, memberName, (Map)currentReferencedObj, otma);
            this.notifyListeners((InteractionEvent)ev);
            return mapViewObject;
        }
        throw new IllegalArgumentException(String.format("Collection type '%s' not supported by framework", currentReferencedObj.getClass().getName()));
    }

    private Collection<?> lookupViewObject(Method method, String memberName, Collection<?> collectionToLookup, OneToManyAssociation otma) {
        Collection<?> collectionViewObject = this.collectionViewObjectsByMethod.get(method);
        if (collectionViewObject == null) {
            collectionViewObject = collectionToLookup instanceof WrapperObject ? collectionToLookup : Proxy.proxy(collectionToLookup, memberName, this, otma);
            this.collectionViewObjectsByMethod.put(method, collectionViewObject);
        }
        return collectionViewObject;
    }

    private Map<?, ?> lookupViewObject(Method method, String memberName, Map<?, ?> mapToLookup, OneToManyAssociation otma) {
        Map<?, ?> mapViewObject = this.mapViewObjectsByMethod.get(method);
        if (mapViewObject == null) {
            mapViewObject = mapToLookup instanceof WrapperObject ? mapToLookup : Proxy.proxy(mapToLookup, memberName, this, otma);
            this.mapViewObjectsByMethod.put(method, mapViewObject);
        }
        return mapViewObject;
    }

    private Object handleCollectionAddToMethod(Object[] args, ObjectAdapter targetAdapter, OneToManyAssociation otma, String methodName) {
        if (args.length != 1) {
            throw new IllegalArgumentException("Invoking a addTo should only have a single argument");
        }
        this.resolveIfRequired(targetAdapter);
        Object argumentObj = this.underlying(args[0]);
        if (argumentObj == null) {
            throw new IllegalArgumentException("Must provide a non-null object to add");
        }
        ObjectAdapter argumentNO = this.getAdapterManager().adapterFor(argumentObj);
        InteractionResult interactionResult = otma.isValidToAdd(targetAdapter, argumentNO).getInteractionResult();
        this.notifyListenersAndVetoIfRequired(interactionResult);
        if (this.getExecutionMode() == WrapperFactory.ExecutionMode.EXECUTE) {
            otma.addElement(targetAdapter, argumentNO);
        }
        this.objectChangedIfRequired(targetAdapter);
        return null;
    }

    private Object handleCollectionRemoveFromMethod(Object[] args, ObjectAdapter targetAdapter, OneToManyAssociation otma, String methodName) {
        if (args.length != 1) {
            throw new IllegalArgumentException("Invoking a removeFrom should only have a single argument");
        }
        this.resolveIfRequired(targetAdapter);
        Object argumentObj = this.underlying(args[0]);
        if (argumentObj == null) {
            throw new IllegalArgumentException("Must provide a non-null object to remove");
        }
        ObjectAdapter argumentAdapter = this.getAdapterManager().adapterFor(argumentObj);
        InteractionResult interactionResult = otma.isValidToRemove(targetAdapter, argumentAdapter).getInteractionResult();
        this.notifyListenersAndVetoIfRequired(interactionResult);
        if (this.getExecutionMode() == WrapperFactory.ExecutionMode.EXECUTE) {
            otma.removeElement(targetAdapter, argumentAdapter);
        }
        this.objectChangedIfRequired(targetAdapter);
        return null;
    }

    private Object handleActionMethod(Object[] args, AuthenticationSession session, ObjectAdapter targetAdapter, ObjectAction noa, String memberName) {
        Object[] underlyingArgs = new Object[args.length];
        int i = 0;
        for (Object arg : args) {
            underlyingArgs[i++] = this.underlying(arg);
        }
        ObjectAdapter[] argAdapters = new ObjectAdapter[underlyingArgs.length];
        int j = 0;
        for (Object underlyingArg : underlyingArgs) {
            argAdapters[j++] = underlyingArg != null ? this.getAdapterManager().adapterFor(underlyingArg) : null;
        }
        InteractionResult interactionResult = noa.isProposedArgumentSetValid(targetAdapter, argAdapters).getInteractionResult();
        this.notifyListenersAndVetoIfRequired(interactionResult);
        if (this.getExecutionMode() == WrapperFactory.ExecutionMode.EXECUTE) {
            ObjectAdapter actionReturnNO = noa.execute(targetAdapter, argAdapters);
            return AdapterUtils.unwrap((ObjectAdapter)actionReturnNO);
        }
        this.objectChangedIfRequired(targetAdapter);
        return null;
    }

    private Object underlying(Object arg) {
        if (arg instanceof WrapperObject) {
            WrapperObject argViewObject = (WrapperObject)arg;
            return argViewObject.wrapped();
        }
        return arg;
    }

    private void checkVisibility(AuthenticationSession session, ObjectAdapter targetObjectAdapter, ObjectMember objectMember) {
        Consent visibleConsent = objectMember.isVisible(this.getAuthenticationSession(), targetObjectAdapter, this.where);
        InteractionResult interactionResult = visibleConsent.getInteractionResult();
        this.notifyListenersAndVetoIfRequired(interactionResult);
    }

    private void checkUsability(AuthenticationSession session, ObjectAdapter targetObjectAdapter, ObjectMember objectMember) {
        InteractionResult interactionResult = objectMember.isUsable(this.getAuthenticationSession(), targetObjectAdapter, this.where).getInteractionResult();
        this.notifyListenersAndVetoIfRequired(interactionResult);
    }

    private void notifyListenersAndVetoIfRequired(InteractionResult interactionResult) {
        InteractionEvent interactionEvent = interactionResult.getInteractionEvent();
        this.notifyListeners(interactionEvent);
        if (interactionEvent.isVeto()) {
            throw this.toException(interactionEvent);
        }
    }

    private String decode(ObjectMember objectMember) {
        if (objectMember instanceof OneToOneAssociation) {
            return "a property";
        }
        if (objectMember instanceof OneToManyAssociation) {
            return "a collection";
        }
        if (objectMember instanceof ObjectAction) {
            return "an action";
        }
        return "an UNKNOWN member type";
    }

    private InteractionException toException(InteractionEvent interactionEvent) {
        if (!interactionEvent.isVeto()) {
            throw new IllegalArgumentException("Provided interactionEvent must be a veto");
        }
        if (interactionEvent instanceof ValidityEvent) {
            ValidityEvent validityEvent = (ValidityEvent)interactionEvent;
            return new InvalidException((InteractionEvent)validityEvent);
        }
        if (interactionEvent instanceof VisibilityEvent) {
            VisibilityEvent visibilityEvent = (VisibilityEvent)interactionEvent;
            return new HiddenException((InteractionEvent)visibilityEvent);
        }
        if (interactionEvent instanceof UsabilityEvent) {
            UsabilityEvent usabilityEvent = (UsabilityEvent)interactionEvent;
            return new DisabledException((InteractionEvent)usabilityEvent);
        }
        throw new IllegalArgumentException("Provided interactionEvent must be a VisibilityEvent, UsabilityEvent or a ValidityEvent");
    }

    private ObjectMember locateAndCheckMember(Method method) {
        ObjectSpecificationDefault objectSpecificationDefault = this.getJavaSpecificationOfOwningClass(method);
        ObjectMember member = objectSpecificationDefault.getMember(method);
        if (member == null) {
            String methodName = method.getName();
            throw new UnsupportedOperationException("Method '" + methodName + "' being invoked does not correspond to any of the object's fields or actions.");
        }
        return member;
    }

    protected boolean isTitleMethod(Method method) {
        return method.equals(this.titleMethod);
    }

    protected boolean isSaveMethod(Method method) {
        return method.equals(this.saveMethod);
    }

    protected boolean isUnderlyingMethod(Method method) {
        return method.equals(this.wrappedMethod);
    }

    private ObjectSpecificationDefault getJavaSpecificationOfOwningClass(Method method) {
        return this.getJavaSpecification(method.getDeclaringClass());
    }

    private ObjectSpecificationDefault getJavaSpecification(Class<?> clazz) {
        ObjectSpecification nos = this.getSpecification(clazz);
        if (!(nos instanceof ObjectSpecificationDefault)) {
            throw new UnsupportedOperationException("Only Java is supported (specification is '" + nos.getClass().getCanonicalName() + "')");
        }
        return (ObjectSpecificationDefault)nos;
    }

    private ObjectSpecification getSpecification(Class<?> type) {
        ObjectSpecification nos = this.getSpecificationLookup().loadSpecification(type);
        return nos;
    }

    protected SpecificationLoader getSpecificationLookup() {
        return this.specificationLookup;
    }

    public AuthenticationSessionProvider getAuthenticationSessionProvider() {
        return this.authenticationSessionProvider;
    }

    protected AuthenticationSession getAuthenticationSession() {
        return this.getAuthenticationSessionProvider().getAuthenticationSession();
    }

    protected AdapterManager getAdapterManager() {
        return this.adapterManager;
    }

    protected ObjectPersistor getObjectPersistor() {
        return this.objectPersistor;
    }
}

