/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.api;

import java.util.List;
import org.apache.jackrabbit.vault.fs.api.FilterSet;
import org.apache.jackrabbit.vault.fs.api.PathFilter;
import org.apache.jackrabbit.vault.fs.api.PathMapping;

public class PathFilterSet
extends FilterSet<PathFilter> {
    public static final PathFilterSet INCLUDE_ALL = (PathFilterSet)new PathFilterSet().addInclude(PathFilter.ALL).seal();
    public static final PathFilterSet EXCLUDE_ALL = (PathFilterSet)new PathFilterSet().addExclude(PathFilter.ALL).seal();
    private boolean onlyRelativePatterns;

    public PathFilterSet() {
    }

    public PathFilterSet(String root) {
        super(root);
    }

    public boolean contains(String path) {
        if (!this.covers(path)) {
            return false;
        }
        List entries = this.getEntries();
        if (entries.isEmpty()) {
            return true;
        }
        boolean result = !entries.get((int)0).include;
        for (FilterSet.Entry entry : entries) {
            if (!((PathFilter)entry.filter).matches(path)) continue;
            result = entry.include;
        }
        return result;
    }

    @Override
    public FilterSet seal() {
        if (!this.isSealed()) {
            super.seal();
            this.onlyRelativePatterns = true;
            for (FilterSet.Entry entry : this.getEntries()) {
                if (entry.include && !((PathFilter)entry.filter).isAbsolute()) continue;
                this.onlyRelativePatterns = false;
                break;
            }
        }
        return this;
    }

    public PathFilterSet translate(PathMapping mapping) {
        if (mapping == null) {
            return this;
        }
        PathFilterSet mapped = new PathFilterSet(mapping.map(this.getRoot()));
        mapped.setImportMode(this.getImportMode());
        for (FilterSet.Entry e : this.getEntries()) {
            if (e.isInclude()) {
                mapped.addInclude(((PathFilter)e.getFilter()).translate(mapping));
                continue;
            }
            mapped.addExclude(((PathFilter)e.getFilter()).translate(mapping));
        }
        mapped.seal();
        return mapped;
    }

    public boolean hasOnlyRelativePatterns() {
        this.seal();
        return this.onlyRelativePatterns;
    }
}

