/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NameParser;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.vault.fs.api.Aggregate;
import org.apache.jackrabbit.vault.fs.impl.AggregateManagerImpl;
import org.apache.jackrabbit.vault.fs.impl.io.AbstractSAXFormatter;
import org.apache.jackrabbit.vault.util.DocViewProperty;
import org.apache.jackrabbit.vault.util.ItemNameComparator;
import org.apache.jackrabbit.vault.util.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DocViewSAXFormatter
extends AbstractSAXFormatter {
    public static final String CDATA_TYPE = "CDATA";
    private final List<Property> props = new ArrayList<Property>();
    private boolean useJcrRoot;
    private Set<String> ignored = new HashSet<String>();

    public DocViewSAXFormatter(Aggregate aggregate, ContentHandler contentHandler) throws RepositoryException {
        super(aggregate, contentHandler);
    }

    private Name getQName(String rawName) throws RepositoryException {
        try {
            return NameParser.parse((String)rawName, (NamespaceResolver)this.nsResolver, (NameFactory)NameFactoryImpl.getInstance());
        }
        catch (NameException e) {
            String msg = "internal error: failed to resolve namespace mappings";
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public void setUseJcrRoot(boolean useJcrRoot) {
        this.useJcrRoot = useJcrRoot;
    }

    @Override
    public void onWalkBegin(Node root) throws RepositoryException {
        super.onWalkBegin(root);
        this.ignored.clear();
        this.ignored.add("jcr:created");
        this.ignored.add("jcr:createdBy");
        this.ignored.add("jcr:baseVersion");
        this.ignored.add("jcr:versionHistory");
        this.ignored.add("jcr:predecessors");
    }

    @Override
    public void onNodeBegin(Node node, boolean included, int level) throws RepositoryException {
        ((AggregateManagerImpl)this.aggregate.getManager()).addNodeTypes(node);
        this.props.clear();
    }

    @Override
    public void onChildren(Node node, int level) throws RepositoryException {
        String name = node.getName();
        String label = Text.getName(node.getPath());
        if (name.equals(this.jcrXMLText)) {
            for (Property prop : this.props) {
                String propName = prop.getName();
                if (!propName.equals(this.jcrXMLCharacters)) continue;
                char[] chars = prop.getValue().getString().toCharArray();
                try {
                    this.contentHandler.characters(chars, 0, chars.length);
                }
                catch (SAXException e) {
                    throw new RepositoryException((Throwable)e);
                }
            }
        } else {
            String elemName = level == 0 && this.useJcrRoot || node.getDepth() == 0 ? this.jcrRoot : ISO9075.encode((String)label);
            AttributesImpl attrs = new AttributesImpl();
            Collections.sort(this.props, ItemNameComparator.INSTANCE);
            for (Property prop : this.props) {
                String attrName = ISO9075.encode((String)prop.getName());
                Name qName = this.getQName(attrName);
                boolean sort = qName.equals(NameConstants.JCR_MIXINTYPES);
                attrs.addAttribute(qName.getNamespaceURI(), qName.getLocalName(), attrName, CDATA_TYPE, DocViewProperty.format(prop, sort));
            }
            Name qName = this.getQName(elemName);
            try {
                this.contentHandler.startElement(qName.getNamespaceURI(), qName.getLocalName(), elemName, attrs);
            }
            catch (SAXException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
    }

    @Override
    public void onNodeEnd(Node node, boolean included, int level) throws RepositoryException {
        String name = node.getName();
        String label = Text.getName(node.getPath());
        if (name.equals(this.jcrXMLText)) {
            return;
        }
        String elemName = node.getDepth() == 0 ? this.jcrRoot : ISO9075.encode((String)label);
        Name qName = this.getQName(elemName);
        try {
            this.contentHandler.endElement(qName.getNamespaceURI(), qName.getLocalName(), elemName);
        }
        catch (SAXException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public void onProperty(Property prop, int level) throws RepositoryException {
        if (this.ignored.contains(prop.getName()) && prop.getDefinition().isProtected()) {
            return;
        }
        this.props.add(prop);
    }

    @Override
    public void onNodeIgnored(Node node, int depth) throws RepositoryException {
        String label = Text.getName(node.getPath());
        String elemName = ISO9075.encode((String)label);
        Name qName = this.getQName(elemName);
        try {
            this.contentHandler.startElement(qName.getNamespaceURI(), qName.getLocalName(), elemName, null);
            this.contentHandler.endElement(qName.getNamespaceURI(), qName.getLocalName(), elemName);
        }
        catch (SAXException e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

