/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.util.xml.serialize.OutputFormat;
import org.apache.jackrabbit.vault.util.xml.serialize.XMLSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FilteredXMLSerializer
extends XMLSerializer {
    private static Logger log = LoggerFactory.getLogger(FilteredXMLSerializer.class);
    private Filter filter = new DefaultFilter();

    public FilteredXMLSerializer(OutputStream outputStream, OutputFormat outputFormat) throws RepositoryException {
        super(outputStream, outputFormat);
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String rawName, Attributes attrs) throws SAXException {
        if (this.filter.isFilteredNamespace(namespaceURI) || this.filter.isFilteredRawName(rawName)) {
            log.debug("Filtering: {" + namespaceURI + "}" + localName + " -> " + rawName);
        } else {
            AttributesImpl fAttrs = new AttributesImpl(attrs);
            for (int i = 0; i < fAttrs.getLength(); ++i) {
                String uri = fAttrs.getURI(i);
                if (!this.filter.isFilteredNamespace(uri)) continue;
                fAttrs.removeAttribute(i);
            }
            super.startElement(namespaceURI, localName, rawName, fAttrs);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        if (this.filter.isFilteredNamespace(namespaceURI) || this.filter.isFilteredRawName(rawName)) {
            log.debug("Filtering: {" + namespaceURI + "}" + localName + " -> " + rawName);
        } else {
            super.endElement(namespaceURI, localName, rawName);
        }
    }

    @Override
    public void endElementIO(String namespaceURI, String localName, String rawName) throws IOException {
        if (this.filter.isFilteredNamespace(namespaceURI) || this.filter.isFilteredRawName(rawName)) {
            log.debug("Filtering: {" + namespaceURI + "}" + localName + " -> " + rawName);
        } else {
            super.endElementIO(namespaceURI, localName, rawName);
        }
    }

    public static class DefaultFilter
    implements Filter {
        private Set<String> namespaces = new HashSet<String>();
        private Set<String> rawNames = new HashSet<String>();

        protected DefaultFilter() {
        }

        @Override
        public void addNamespaceFilter(String namespaceURI) {
            this.namespaces.add(namespaceURI);
        }

        @Override
        public void removeNamespaceFilter(String namespaceURI) {
            this.namespaces.remove(namespaceURI);
        }

        @Override
        public String[] getNamespaceFilters() {
            return this.namespaces.toArray(new String[this.namespaces.size()]);
        }

        @Override
        public void addRawNameFilter(String rawName) {
            this.rawNames.add(rawName);
        }

        @Override
        public void removeRawNameFilter(String rawName) {
            this.rawNames.remove(rawName);
        }

        @Override
        public String[] getRawNameFilters() {
            return this.rawNames.toArray(new String[this.rawNames.size()]);
        }

        @Override
        public boolean isFilteredNamespace(String namespaceURI) {
            return this.namespaces.contains(namespaceURI);
        }

        @Override
        public boolean isFilteredRawName(String rawName) {
            return this.rawNames.contains(rawName);
        }
    }

    public static interface Filter {
        public void addNamespaceFilter(String var1);

        public void removeNamespaceFilter(String var1);

        public String[] getNamespaceFilters();

        public void addRawNameFilter(String var1);

        public void removeRawNameFilter(String var1);

        public String[] getRawNameFilters();

        public boolean isFilteredNamespace(String var1);

        public boolean isFilteredRawName(String var1);
    }
}

