/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.PackageManager;
import org.apache.jackrabbit.vault.packaging.impl.JcrPackageDefinitionImpl;
import org.apache.jackrabbit.vault.packaging.impl.JcrPackageImpl;
import org.apache.jackrabbit.vault.packaging.impl.JcrPackageManagerImpl;
import org.apache.jackrabbit.vault.packaging.impl.PackageManagerImpl;

public class PackagingService {
    public static PackageManager getPackageManager() {
        return new PackageManagerImpl();
    }

    public static JcrPackageManager getPackageManager(Session session) {
        return new JcrPackageManagerImpl(session);
    }

    public static JcrPackageDefinition createPackageDefinition(Node defNode) {
        return new JcrPackageDefinitionImpl(defNode);
    }

    public static JcrPackage open(Node node, boolean allowInvalid) throws RepositoryException {
        JcrPackageImpl pack = new JcrPackageImpl(node);
        if (pack.isValid()) {
            return pack;
        }
        if (allowInvalid && node.isNodeType("nt:hierarchyNode") && node.hasProperty("jcr:content/jcr:data")) {
            return pack;
        }
        return null;
    }
}

