/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.impl;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.fs.io.Importer;
import org.apache.jackrabbit.vault.packaging.InstallContext;
import org.apache.jackrabbit.vault.packaging.InstallHookProcessor;
import org.apache.jackrabbit.vault.packaging.VaultPackage;

public class InstallContextImpl
implements InstallContext {
    private final Session session;
    private final Node importRoot;
    private final VaultPackage pack;
    private InstallContext.Phase phase = InstallContext.Phase.PREPARE;
    private final Importer importer;
    private final InstallHookProcessor hooks;

    public InstallContextImpl(Node importRoot, VaultPackage pack, Importer importer, InstallHookProcessor hooks) throws RepositoryException {
        this.session = importRoot.getSession();
        this.importRoot = importRoot;
        this.pack = pack;
        this.importer = importer;
        this.hooks = hooks;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public VaultPackage getPackage() {
        return this.pack;
    }

    @Override
    public ImportOptions getOptions() {
        return this.importer.getOptions();
    }

    @Override
    public InstallContext.Phase getPhase() {
        return this.phase;
    }

    protected void setPhase(InstallContext.Phase phase) {
        this.phase = phase;
    }

    protected Importer getImporter() {
        return this.importer;
    }

    protected InstallHookProcessor getHooks() {
        return this.hooks;
    }

    protected Node getImportRoot() {
        return this.importRoot;
    }
}

