/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.impl;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.PackageManager;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.jackrabbit.vault.packaging.impl.JcrPackageDefinitionImpl;
import org.apache.jackrabbit.vault.packaging.impl.JcrPackageImpl;
import org.apache.jackrabbit.vault.packaging.impl.JcrPackageManagerImpl;
import org.apache.jackrabbit.vault.packaging.impl.PackageManagerImpl;

@Component(metatype=false, immediate=true)
@Service(value={Packaging.class})
public class PackagingImpl
implements Packaging {
    private final PackageManager pkgManager = new PackageManagerImpl();

    @Override
    public PackageManager getPackageManager() {
        return this.pkgManager;
    }

    @Override
    public JcrPackageManager getPackageManager(Session session) {
        return new JcrPackageManagerImpl(session);
    }

    @Override
    public JcrPackageDefinition createPackageDefinition(Node defNode) {
        return new JcrPackageDefinitionImpl(defNode);
    }

    @Override
    public JcrPackage open(Node node, boolean allowInvalid) throws RepositoryException {
        JcrPackageImpl pack = new JcrPackageImpl(node);
        if (pack.isValid()) {
            return pack;
        }
        if (allowInvalid && node.isNodeType("nt:hierarchyNode") && node.hasProperty("jcr:content/jcr:data")) {
            return pack;
        }
        return null;
    }
}

