/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.jackrabbit.vault.fs.api.Artifact;
import org.apache.jackrabbit.vault.fs.api.VaultFile;
import org.apache.jackrabbit.vault.fs.impl.io.CompressionUtil;
import org.apache.jackrabbit.vault.fs.io.AbstractExporter;
import org.apache.jackrabbit.vault.fs.io.ExportInfo;

public class JarExporter
extends AbstractExporter {
    private static final Set<Integer> COMPRESSED_LEVELS = new HashSet<Integer>(Arrays.asList(-1, 0, 9));
    private JarOutputStream jOut;
    private OutputStream out;
    private File jarFile;
    private final int level;
    private final boolean compressedLevel;

    public JarExporter(File jarFile) {
        this(jarFile, -1);
    }

    public JarExporter(File jarFile, int level) {
        this.compressedLevel = COMPRESSED_LEVELS.contains(level);
        this.jarFile = jarFile;
        this.level = level;
    }

    public JarExporter(OutputStream out) {
        this(out, -1);
    }

    public JarExporter(OutputStream out, int level) {
        this.compressedLevel = COMPRESSED_LEVELS.contains(level);
        this.out = out;
        this.level = level;
    }

    @Override
    public void open() throws IOException {
        if (this.jOut == null) {
            if (this.jarFile != null) {
                this.jOut = new JarOutputStream(new FileOutputStream(this.jarFile));
                this.jOut.setLevel(this.level);
            } else if (this.out != null) {
                this.jOut = new JarOutputStream(this.out);
                this.jOut.setLevel(this.level);
            } else {
                throw new IllegalArgumentException("Either out or jarFile needs to be set.");
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.jOut != null) {
            this.jOut.close();
            this.jOut = null;
        }
    }

    @Override
    public void createDirectory(VaultFile file, String relPath) throws RepositoryException, IOException {
        ZipEntry e = new ZipEntry(this.getPlatformFilePath(file, relPath) + "/");
        this.jOut.putNextEntry(e);
        this.jOut.closeEntry();
        this.track("A", relPath);
        this.exportInfo.update(ExportInfo.Type.MKDIR, e.getName());
    }

    @Override
    public void createDirectory(String relPath) throws IOException {
        ZipEntry e = new ZipEntry(relPath + "/");
        this.jOut.putNextEntry(e);
        this.jOut.closeEntry();
        this.exportInfo.update(ExportInfo.Type.MKDIR, e.getName());
    }

    @Override
    public void writeFile(VaultFile file, String relPath) throws RepositoryException, IOException {
        boolean compress;
        ZipEntry e = new ZipEntry(this.getPlatformFilePath(file, relPath));
        Artifact a = file.getArtifact();
        boolean bl = compress = this.compressedLevel || CompressionUtil.isCompressible(a) >= 0;
        if (!compress) {
            this.jOut.setLevel(0);
        }
        if (a.getLastModified() > 0L) {
            e.setTime(a.getLastModified());
        }
        this.track("A", relPath);
        this.exportInfo.update(ExportInfo.Type.ADD, e.getName());
        this.jOut.putNextEntry(e);
        switch (a.getPreferredAccess()) {
            case NONE: {
                throw new RepositoryException("Artifact has no content.");
            }
            case SPOOL: {
                CloseShieldOutputStream nout = new CloseShieldOutputStream((OutputStream)this.jOut);
                a.spool((OutputStream)nout);
                break;
            }
            case STREAM: {
                CloseShieldOutputStream nout = new CloseShieldOutputStream((OutputStream)this.jOut);
                InputStream in = a.getInputStream();
                IOUtils.copy((InputStream)in, (OutputStream)nout);
                in.close();
            }
        }
        this.jOut.closeEntry();
        if (!compress) {
            this.jOut.setLevel(this.level);
        }
    }

    @Override
    public void writeFile(InputStream in, String relPath) throws IOException {
        ZipEntry e = new ZipEntry(relPath);
        this.exportInfo.update(ExportInfo.Type.ADD, e.getName());
        this.jOut.putNextEntry(e);
        CloseShieldOutputStream nout = new CloseShieldOutputStream((OutputStream)this.jOut);
        IOUtils.copy((InputStream)in, (OutputStream)nout);
        in.close();
        this.jOut.closeEntry();
    }

    public void write(ZipFile zip, ZipEntry entry) throws IOException {
        this.track("A", entry.getName());
        if (!this.compressedLevel) {
            this.jOut.setLevel(0);
        }
        this.exportInfo.update(ExportInfo.Type.ADD, entry.getName());
        ZipEntry copy = new ZipEntry(entry);
        copy.setCompressedSize(-1L);
        this.jOut.putNextEntry(copy);
        if (!entry.isDirectory()) {
            InputStream in = zip.getInputStream(entry);
            IOUtils.copy((InputStream)in, (OutputStream)this.jOut);
            in.close();
        }
        this.jOut.closeEntry();
        if (!this.compressedLevel) {
            this.jOut.setLevel(this.level);
        }
    }
}

