/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.events.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.events.PackageEvent;
import org.apache.jackrabbit.vault.packaging.events.PackageEventListener;
import org.apache.jackrabbit.vault.packaging.events.impl.PackageEventDispatcher;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={PackageEventDispatcher.class}, property={"service.vendor=The Apache Software Foundation"}, reference={@Reference(name="packageEventListener", service=PackageEventListener.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindPackageEventListener", unbind="unbindPackageEventListener")})
public class PackageEventDispatcherImpl
implements PackageEventDispatcher {
    private static final Logger log = LoggerFactory.getLogger(PackageEventDispatcherImpl.class);
    private ConcurrentHashMap<Object, PackageEventListener> listeners = new ConcurrentHashMap();

    public void bindPackageEventListener(PackageEventListener listener, Map<String, Object> props) {
        this.listeners.put(props.get("component.id"), listener);
        log.debug("Registering package event listener {}", (Object)listener.getClass().getName());
    }

    protected void unbindPackageEventListener(PackageEventListener listener, Map<String, Object> props) {
        if (this.listeners.remove(props.get("component.id")) != null) {
            log.debug("Unregistering package event listener {}", (Object)listener.getClass().getName());
        } else {
            log.warn("unable to unregister package event listener {}", (Object)listener.getClass().getName());
        }
    }

    @Override
    public void dispatch(@Nonnull PackageEvent.Type type, @Nonnull PackageId id, @Nullable PackageId[] related) {
        EventImpl event = new EventImpl(type, id, related);
        for (PackageEventListener l : this.listeners.values()) {
            try {
                l.onPackageEvent(event);
            }
            catch (Throwable throwable) {}
        }
    }

    private static final class EventImpl
    implements PackageEvent {
        private final PackageEvent.Type type;
        private final PackageId id;
        private final PackageId[] related;

        public EventImpl(PackageEvent.Type type, PackageId id, PackageId[] related) {
            this.type = type;
            this.id = id;
            this.related = related;
        }

        @Override
        @Nonnull
        public PackageEvent.Type getType() {
            return this.type;
        }

        @Override
        @Nonnull
        public PackageId getId() {
            return this.id;
        }

        @Override
        @CheckForNull
        public PackageId[] getRelatedIds() {
            return this.related;
        }
    }
}

