/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.impl;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.PackageManager;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.jackrabbit.vault.packaging.events.impl.PackageEventDispatcher;
import org.apache.jackrabbit.vault.packaging.impl.JcrPackageDefinitionImpl;
import org.apache.jackrabbit.vault.packaging.impl.JcrPackageManagerImpl;
import org.apache.jackrabbit.vault.packaging.impl.PackageManagerImpl;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Packaging.class}, immediate=true, property={"service.vendor=The Apache Software Foundation"})
public class PackagingImpl
implements Packaging {
    @Reference
    private PackageEventDispatcher eventDispatcher;
    private final PackageManagerImpl pkgManager = new PackageManagerImpl();

    public PackagingImpl() {
        this.pkgManager.setDispatcher(this.eventDispatcher);
    }

    @Override
    public PackageManager getPackageManager() {
        return this.pkgManager;
    }

    @Override
    public JcrPackageManager getPackageManager(Session session) {
        JcrPackageManagerImpl mgr = new JcrPackageManagerImpl(session);
        mgr.setDispatcher(this.eventDispatcher);
        return mgr;
    }

    @Override
    public JcrPackageDefinition createPackageDefinition(Node defNode) {
        return new JcrPackageDefinitionImpl(defNode);
    }

    @Override
    public JcrPackage open(Node node, boolean allowInvalid) throws RepositoryException {
        JcrPackageManager pMgr = this.getPackageManager(node.getSession());
        return pMgr.open(node, allowInvalid);
    }
}

