/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.impl;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.regex.PatternSyntaxException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.fs.io.Importer;
import org.apache.jackrabbit.vault.fs.io.ZipArchive;
import org.apache.jackrabbit.vault.packaging.InstallContext;
import org.apache.jackrabbit.vault.packaging.InstallHookProcessor;
import org.apache.jackrabbit.vault.packaging.InstallHookProcessorFactory;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.PackageProperties;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.jackrabbit.vault.packaging.impl.AdminPermissionChecker;
import org.apache.jackrabbit.vault.packaging.impl.InstallContextImpl;
import org.apache.jackrabbit.vault.packaging.impl.InstallHookProcessorImpl;
import org.apache.jackrabbit.vault.packaging.impl.PackagePropertiesImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipVaultPackage
extends PackagePropertiesImpl
implements VaultPackage {
    private static final Logger log = LoggerFactory.getLogger(ZipVaultPackage.class);
    private Archive archive;

    public ZipVaultPackage(File file, boolean isTmpFile) throws IOException {
        this(file, isTmpFile, false);
    }

    public ZipVaultPackage(File file, boolean isTmpFile, boolean strict) throws IOException {
        this(new ZipArchive(file, isTmpFile), strict);
    }

    public ZipVaultPackage(Archive archive, boolean strict) throws IOException {
        this.archive = archive;
        if (strict) {
            try {
                archive.open(true);
            }
            catch (IOException e) {
                log.error("Error while loading package {}.", (Object)archive);
                throw e;
            }
        }
    }

    @Override
    public void close() {
        if (this.archive != null) {
            this.archive.close();
            this.archive = null;
        }
    }

    @Override
    public Archive getArchive() {
        if (this.archive == null) {
            log.error("Package already closed: {}", (Object)this.getId());
            throw new IllegalStateException("Package already closed: " + this.getId());
        }
        try {
            this.archive.open(false);
        }
        catch (IOException e) {
            log.error("Archive not valid.", (Throwable)e);
            throw new IllegalStateException("Archive not valid.", e);
        }
        return this.archive;
    }

    @Override
    public boolean isValid() {
        try {
            return this.getMetaInf().getFilter() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isClosed() {
        return this.archive == null;
    }

    @Override
    public File getFile() {
        return this.archive instanceof ZipArchive ? ((ZipArchive)this.archive).getFile() : null;
    }

    @Override
    public MetaInf getMetaInf() {
        try {
            return this.getArchive().getMetaInf();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public long getSize() {
        return this.archive instanceof ZipArchive ? ((ZipArchive)this.archive).getFileSize() : -1L;
    }

    @Override
    public void extract(Session session, ImportOptions opts) throws RepositoryException, PackageException {
        this.extract(this.prepareExtract(session, opts), null);
    }

    @Override
    public PackageProperties getProperties() {
        return this;
    }

    protected InstallContextImpl prepareExtract(Session session, ImportOptions opts) throws RepositoryException, PackageException {
        String cndPattern;
        InstallHookProcessor hooks;
        if (!this.isValid()) {
            throw new IllegalStateException("Package not valid.");
        }
        InstallHookProcessor installHookProcessor = hooks = opts instanceof InstallHookProcessorFactory ? ((InstallHookProcessorFactory)((Object)opts)).createInstallHookProcessor() : new InstallHookProcessorImpl();
        if (!opts.isDryRun()) {
            hooks.registerHooks(this.archive, opts.getHookClassLoader());
        }
        if ((this.requiresRoot() || hooks.hasHooks()) && !AdminPermissionChecker.hasAdministrativePermissions(session)) {
            log.error("Package extraction requires admin session.");
            throw new PackageException("Package extraction requires admin session (userid not allowed).");
        }
        Importer importer = new Importer(opts);
        AccessControlHandling ac = this.getACHandling();
        if (opts.getAccessControlHandling() == null) {
            opts.setAccessControlHandling(ac);
        }
        if ((cndPattern = this.getProperty("cndPattern")) != null) {
            try {
                opts.setCndPattern(cndPattern);
            }
            catch (PatternSyntaxException e) {
                throw new PackageException("Specified CND pattern not valid.", e);
            }
        }
        return new InstallContextImpl(session, "/", this, importer, hooks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extract(InstallContextImpl ctx, List<String> subPackages) throws RepositoryException, PackageException {
        log.debug("Extracting {}", (Object)this.getId());
        InstallHookProcessor hooks = ctx.getHooks();
        Importer importer = ctx.getImporter();
        try {
            if (!hooks.execute(ctx)) {
                ctx.setPhase(InstallContext.Phase.PREPARE_FAILED);
                hooks.execute(ctx);
                throw new PackageException("Import aborted during prepare phase.");
            }
            try {
                importer.run(this.archive, ctx.getSession(), ctx.getImportRootPath());
            }
            catch (Exception e) {
                log.error("Error during install.", (Throwable)e);
                ctx.setPhase(InstallContext.Phase.INSTALL_FAILED);
                hooks.execute(ctx);
                throw new PackageException(e);
            }
            ctx.setPhase(InstallContext.Phase.INSTALLED);
            hooks.execute(ctx);
            if (importer.hasErrors() && ctx.getOptions().isStrict()) {
                ctx.setPhase(InstallContext.Phase.INSTALL_FAILED);
                hooks.execute(ctx);
                throw new PackageException("Errors during import.");
            }
        }
        finally {
            ctx.setPhase(InstallContext.Phase.END);
            hooks.execute(ctx);
        }
        if (subPackages != null) {
            subPackages.addAll(importer.getSubPackages());
        }
        log.debug("Extracting {} completed.", (Object)this.getId());
    }

    @Override
    protected Properties getPropertiesMap() {
        return this.getMetaInf().getProperties();
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }
}

