/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.api;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.vault.fs.api.PathMapping;

public final class RegexpPathMapping
implements PathMapping {
    @Nonnull
    private final Map<Pattern, String> pathsMapping = new HashMap<Pattern, String>();

    @Nonnull
    public <K, V> RegexpPathMapping addAllMappings(@Nonnull Map<K, V> pathsMappingMap) {
        for (Map.Entry<K, V> entry : pathsMappingMap.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            if (key == null || value == null) continue;
            this.addMapping(String.valueOf(key), String.valueOf(value));
        }
        return this;
    }

    @Nonnull
    public RegexpPathMapping addMapping(@Nonnull String fromPattern, @Nonnull String toPattern) {
        this.pathsMapping.put(Pattern.compile(fromPattern), toPattern);
        return this;
    }

    @Nonnull
    public RegexpPathMapping merge(@Nullable RegexpPathMapping base) {
        if (base != null) {
            this.pathsMapping.putAll(base.pathsMapping);
        }
        return this;
    }

    @Override
    @Nonnull
    public String map(@Nonnull String path) {
        for (Map.Entry<Pattern, String> pathMapping : this.pathsMapping.entrySet()) {
            Matcher matcher = pathMapping.getKey().matcher(path);
            if (!matcher.matches()) continue;
            return matcher.replaceAll(pathMapping.getValue());
        }
        return path;
    }

    @Override
    @Nonnull
    public String map(@Nonnull String path, boolean reverse) {
        if (reverse) {
            throw new IllegalArgumentException("No reverse mapping not supported with regexp mapping");
        }
        return this.map(path);
    }
}

