/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.fs.config.DefaultMetaInf;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.fs.config.VaultSettings;
import org.apache.jackrabbit.vault.fs.io.AbstractArchive;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.util.InputStreamPump;
import org.apache.jackrabbit.vault.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryArchive
extends AbstractArchive
implements InputStreamPump.Pump {
    private static final Logger log = LoggerFactory.getLogger(MemoryArchive.class);
    private final VirtualEntry root;
    private final DefaultMetaInf inf;
    private boolean cacheMetaOnly = false;

    public MemoryArchive(boolean metaOnly) throws IOException {
        this.cacheMetaOnly = metaOnly;
        this.root = new VirtualEntry(null, "", 0L, null);
        this.inf = new DefaultMetaInf();
    }

    @Override
    public void run(InputStream in) throws Exception {
        ZipEntry entry;
        ZipInputStream zin = new ZipInputStream(new BufferedInputStream(in));
        boolean hasRoot = false;
        while ((entry = zin.getNextEntry()) != null) {
            byte[] data;
            String name = entry.getName();
            boolean isMeta = name.startsWith("META-INF/vault/");
            if (!hasRoot && name.startsWith("jcr_root/")) {
                hasRoot = true;
            }
            if (!isMeta && this.cacheMetaOnly) continue;
            String[] names = Text.explode(name, 47);
            byte[] byArray = data = entry.isDirectory() ? null : IOUtils.toByteArray((InputStream)zin);
            if (names.length > 0) {
                VirtualEntry je = this.root;
                for (int i = 0; i < names.length; ++i) {
                    je = i == names.length - 1 && !entry.isDirectory() ? je.add(names[i], MemoryArchive.safeGetTime(entry), data) : je.add(names[i], 0L, null);
                }
                if (log.isDebugEnabled()) {
                    log.debug("scanning jar: {}", (Object)name);
                }
            }
            if (!isMeta) continue;
            this.inf.load(data == null ? null : new ByteArrayInputStream(data), "inputstream://" + name);
        }
        if (hasRoot && !this.root.children.containsKey("jcr_root")) {
            this.root.add("jcr_root", 0L, null);
        }
        if (this.inf.getSettings() == null) {
            VaultSettings settings = new VaultSettings();
            settings.getIgnoredNames().add(".svn");
            this.inf.setSettings(settings);
        }
    }

    @Override
    public void open(boolean strict) throws IOException {
    }

    @Override
    public InputStream openInputStream(Archive.Entry entry) throws IOException {
        VirtualEntry ve = (VirtualEntry)entry;
        if (ve == null || ve.data == null) {
            return null;
        }
        return new ByteArrayInputStream(ve.data);
    }

    @Override
    public VaultInputSource getInputSource(Archive.Entry entry) throws IOException {
        final VirtualEntry ve = (VirtualEntry)entry;
        if (ve == null) {
            return null;
        }
        return new VaultInputSource(){

            @Override
            public String getSystemId() {
                String systemId = super.getSystemId();
                if (systemId == null) {
                    systemId = ve.getPath();
                    this.setSystemId(systemId);
                }
                return systemId;
            }

            @Override
            public InputStream getByteStream() {
                return ve.data == null ? null : new ByteArrayInputStream(ve.data);
            }

            @Override
            public long getContentLength() {
                return ve.data == null ? -1L : (long)ve.data.length;
            }

            @Override
            public long getLastModified() {
                return ve.time;
            }
        };
    }

    @Override
    public Archive.Entry getRoot() throws IOException {
        return this.root;
    }

    @Override
    public MetaInf getMetaInf() {
        return this.inf;
    }

    @Override
    public void close() {
    }

    private static long safeGetTime(ZipEntry e) {
        try {
            return e.getTime();
        }
        catch (Exception e1) {
            return 0L;
        }
    }

    private static class VirtualEntry
    implements Archive.Entry {
        private final VirtualEntry parent;
        private final String name;
        private final long time;
        private final byte[] data;
        private Map<String, VirtualEntry> children;

        private VirtualEntry(VirtualEntry parent, String name, long time, byte[] data) {
            this.parent = parent;
            this.name = name;
            this.time = time;
            this.data = data;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Nonnull
        public String getPath() {
            return this.getPath(new StringBuilder()).toString();
        }

        @Nonnull
        private StringBuilder getPath(@Nonnull StringBuilder sb) {
            return this.parent == null ? sb : this.parent.getPath(sb).append('/').append(this.name);
        }

        @Override
        public boolean isDirectory() {
            return this.data == null;
        }

        @Override
        public Collection<? extends Archive.Entry> getChildren() {
            return this.children == null ? Collections.emptyList() : this.children.values();
        }

        @Override
        public Archive.Entry getChild(String name) {
            return this.children == null ? null : this.children.get(name);
        }

        @Nonnull
        public VirtualEntry add(@Nonnull String name, long time, @Nullable byte[] data) {
            VirtualEntry ret;
            if (this.children != null && (ret = this.children.get(name)) != null) {
                return ret;
            }
            VirtualEntry ve = new VirtualEntry(this, name, time, data);
            if (this.children == null) {
                this.children = new LinkedHashMap<String, VirtualEntry>();
            }
            this.children.put(name, ve);
            return ve;
        }
    }
}

