/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.filter;

import java.util.regex.Pattern;
import org.apache.jackrabbit.vault.fs.api.DumpContext;
import org.apache.jackrabbit.vault.fs.api.PathFilter;
import org.apache.jackrabbit.vault.fs.api.PathMapping;

public class DefaultPathFilter
implements PathFilter {
    private Pattern regex;

    public DefaultPathFilter() {
    }

    public DefaultPathFilter(String pattern) {
        this.setPattern(pattern);
    }

    public void setPattern(String pattern) {
        this.regex = Pattern.compile(pattern);
    }

    public String getPattern() {
        return this.regex.pattern();
    }

    public boolean matches(String path) {
        return this.regex.matcher(path).matches();
    }

    public boolean isAbsolute() {
        return this.regex.pattern().startsWith("/");
    }

    public PathFilter translate(PathMapping mapping) {
        if (mapping == null) {
            return this;
        }
        String pattern = this.regex.pattern();
        if (!pattern.startsWith("/")) {
            return this;
        }
        return new DefaultPathFilter(mapping.map(pattern));
    }

    public void dump(DumpContext ctx, boolean isLast) {
        ctx.printf(isLast, "%s:", this.getClass().getSimpleName());
        ctx.indent(isLast);
        ctx.printf(true, "regex: %s", this.regex.toString());
        ctx.outdent();
    }
}

