/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.vault.fs.api.AggregateManager;
import org.apache.jackrabbit.vault.fs.api.Aggregator;
import org.apache.jackrabbit.vault.fs.api.ArtifactHandler;
import org.apache.jackrabbit.vault.fs.api.DumpContext;
import org.apache.jackrabbit.vault.fs.api.ImportInfo;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.fs.api.RepositoryAddress;
import org.apache.jackrabbit.vault.fs.api.VaultFsConfig;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.AbstractVaultFsConfig;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.impl.AggregateImpl;
import org.apache.jackrabbit.vault.fs.impl.AggregatorProvider;
import org.apache.jackrabbit.vault.fs.impl.ArtifactSetImpl;
import org.apache.jackrabbit.vault.fs.impl.aggregator.RootAggregator;
import org.apache.jackrabbit.vault.fs.spi.CNDReader;
import org.apache.jackrabbit.vault.fs.spi.NodeTypeInstaller;
import org.apache.jackrabbit.vault.fs.spi.ServiceProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateManagerImpl
implements AggregateManager {
    private static final String DEFAULT_CONFIG = "org/apache/jackrabbit/vault/fs/config/defaultConfig-1.1.xml";
    private static final String DEFAULT_WSP_FILTER = "org/apache/jackrabbit/vault/fs/config/defaultFilter-1.0.xml";
    private static final String DEFAULT_NODETYPES = "org/apache/jackrabbit/vault/fs/config/nodetypes.cnd";
    private Session session;
    private final boolean ownSession;
    private final RepositoryAddress mountpoint;
    private final AggregatorProvider aggregatorProvider;
    private final List<ArtifactHandler> artifactHandlers;
    private final WorkspaceFilter workspaceFilter;
    private AggregatorTracker tracker;
    private final Set<String> nodeTypes = new HashSet<String>();
    private final Map<String, String> nameCache = new ReferenceMap(2, 2);
    private final VaultFsConfig config;
    private final AggregateImpl root;

    public static AggregateManager mount(VaultFsConfig config, WorkspaceFilter wspFilter, RepositoryAddress mountpoint, Session session) throws RepositoryException {
        assert (mountpoint.getWorkspace().equals(session.getWorkspace().getName()));
        if (config == null) {
            config = AggregateManagerImpl.getDefaultConfig();
        }
        if (wspFilter == null) {
            wspFilter = AggregateManagerImpl.getDefaultWorkspaceFilter();
        }
        Node rootNode = session.getNode(mountpoint.getPath());
        return new AggregateManagerImpl(config, wspFilter, mountpoint, rootNode, false);
    }

    public static AggregateManager mount(VaultFsConfig config, WorkspaceFilter wspFilter, Repository rep, Credentials credentials, RepositoryAddress mountpoint) throws RepositoryException {
        Node rootNode;
        if (config == null) {
            config = AggregateManagerImpl.getDefaultConfig();
        }
        if (wspFilter == null) {
            wspFilter = AggregateManagerImpl.getDefaultWorkspaceFilter();
        }
        String wspName = mountpoint.getWorkspace();
        try {
            rootNode = rep.login(credentials, wspName).getNode(mountpoint.getPath());
        }
        catch (LoginException e) {
            if (wspName == null) {
                rootNode = rep.login(credentials, "crx.default").getNode(mountpoint.getPath());
            }
            throw e;
        }
        return new AggregateManagerImpl(config, wspFilter, mountpoint, rootNode, true);
    }

    public static VaultFsConfig getDefaultConfig() {
        try {
            InputStream in = AggregateManagerImpl.class.getClassLoader().getResourceAsStream(DEFAULT_CONFIG);
            if (in == null) {
                throw new InternalError("Default config not in classpath: org/apache/jackrabbit/vault/fs/config/defaultConfig-1.1.xml");
            }
            return AbstractVaultFsConfig.load(in, DEFAULT_CONFIG);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Internal error while parsing config.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Internal error while parsing config.", e);
        }
    }

    public static DefaultWorkspaceFilter getDefaultWorkspaceFilter() {
        try {
            InputStream in = AggregateManagerImpl.class.getClassLoader().getResourceAsStream(DEFAULT_WSP_FILTER);
            if (in == null) {
                throw new InternalError("Default filter not in classpath: org/apache/jackrabbit/vault/fs/config/defaultFilter-1.0.xml");
            }
            DefaultWorkspaceFilter filter = new DefaultWorkspaceFilter();
            filter.load(in);
            return filter;
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Internal error while parsing config.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Internal error while parsing config.", e);
        }
    }

    @Override
    public void unmount() throws RepositoryException {
        this.assertMounted();
        if (this.ownSession) {
            this.session.logout();
        }
        this.session = null;
    }

    @Override
    public AggregateImpl getRoot() throws RepositoryException {
        this.assertMounted();
        return this.root;
    }

    @Override
    public RepositoryAddress getMountpoint() {
        return this.mountpoint;
    }

    private AggregateManagerImpl(VaultFsConfig config, WorkspaceFilter wspFilter, RepositoryAddress mountpoint, Node rootNode, boolean ownSession) throws RepositoryException {
        this.session = rootNode.getSession();
        this.mountpoint = mountpoint;
        this.ownSession = ownSession;
        this.config = config;
        this.workspaceFilter = wspFilter;
        this.aggregatorProvider = new AggregatorProvider(config.getAggregators());
        this.artifactHandlers = Collections.unmodifiableList(config.getHandlers());
        Aggregator rootAggregator = rootNode.getDepth() == 0 ? new RootAggregator() : this.getAggregator(rootNode, null);
        this.root = new AggregateImpl(this, rootNode.getPath(), rootAggregator);
        this.initNodeTypes();
    }

    @Override
    public Set<String> getNodeTypes() {
        return this.nodeTypes;
    }

    @Override
    public void addNodeTypes(Node node) throws RepositoryException {
        this.internalAddNodeType(node.getPrimaryNodeType());
        for (NodeType nt : node.getMixinNodeTypes()) {
            this.internalAddNodeType(nt);
        }
    }

    public String getNamespaceURI(String prefix) throws RepositoryException {
        return this.session.getNamespaceURI(prefix);
    }

    public String cacheString(String string) {
        String ret = this.nameCache.get(string);
        if (ret == null) {
            ret = new String(string);
            this.nameCache.put(ret, ret);
        }
        return ret;
    }

    @Override
    public void startTracking(ProgressTrackerListener pTracker) {
        this.tracker = new AggregatorTracker(pTracker);
    }

    @Override
    public void stopTracking() {
        if (this.tracker != null) {
            this.tracker.log(true);
            this.tracker = null;
        }
    }

    public void onAggregateCreated() {
        if (this.tracker != null) {
            this.tracker.onCreated();
        }
    }

    public void onAggregateCollected() {
        if (this.tracker != null) {
            this.tracker.onCollected();
        }
    }

    public void onAggregatePrepared() {
        if (this.tracker != null) {
            this.tracker.onPrepared();
        }
    }

    private void internalAddNodeType(NodeType nodeType) {
        if (nodeType != null && !this.nodeTypes.contains(nodeType.getName())) {
            PropertyDefinition[] propDefs;
            NodeType[] superTypes;
            this.nodeTypes.add(nodeType.getName());
            for (NodeType superType : superTypes = nodeType.getSupertypes()) {
                this.nodeTypes.add(superType.getName());
            }
            NodeDefinition[] nodeDefs = nodeType.getChildNodeDefinitions();
            if (nodeDefs != null) {
                for (NodeDefinition nodeDef : nodeDefs) {
                    this.internalAddNodeType(nodeDef.getDefaultPrimaryType());
                    NodeType[] reqs = nodeDef.getRequiredPrimaryTypes();
                    if (reqs == null) continue;
                    for (NodeType req : reqs) {
                        this.internalAddNodeType(req);
                    }
                }
            }
            if ((propDefs = nodeType.getPropertyDefinitions()) != null) {
                for (PropertyDefinition propDef : propDefs) {
                    String[] vcs;
                    if (propDef.getRequiredType() != 9 && propDef.getRequiredType() != 10 || (vcs = propDef.getValueConstraints()) == null) continue;
                    for (String vc : vcs) {
                        try {
                            this.internalAddNodeType(this.session.getWorkspace().getNodeTypeManager().getNodeType(vc));
                        }
                        catch (RepositoryException e) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    private void initNodeTypes() throws RepositoryException {
        try {
            this.session.getWorkspace().getNodeTypeManager().getNodeType("vlt:HierarchyNode");
            this.session.getWorkspace().getNodeTypeManager().getNodeType("vlt:FullCoverage");
            return;
        }
        catch (RepositoryException e) {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_NODETYPES);
            try {
                NodeTypeInstaller installer = ServiceProviderFactory.getProvider().getDefaultNodeTypeInstaller(this.session);
                CNDReader types = ServiceProviderFactory.getProvider().getCNDReader();
                types.read(new InputStreamReader(in, "utf8"), DEFAULT_NODETYPES, null);
                installer.install(null, types);
            }
            catch (Exception e2) {
                throw new RepositoryException("Error while importing nodetypes.", (Throwable)e2);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            return;
        }
    }

    @Override
    public Aggregator getAggregator(Node node, String path) throws RepositoryException {
        return this.aggregatorProvider.getAggregator(node, path);
    }

    @Override
    public WorkspaceFilter getWorkspaceFilter() {
        return this.workspaceFilter;
    }

    public ImportInfo writeAggregate(AggregateImpl node, String reposName, ArtifactSetImpl artifacts) throws RepositoryException, IOException {
        this.assertMounted();
        if (reposName == null) {
            for (ArtifactHandler artifactHandler : this.artifactHandlers) {
                ImportInfo info = artifactHandler.accept(this.session, node, artifacts);
                if (info == null) continue;
                node.invalidate();
                return info;
            }
        } else {
            for (ArtifactHandler artifactHandler : this.artifactHandlers) {
                ImportInfo info = artifactHandler.accept(this.session, node, reposName, artifacts);
                if (info == null) continue;
                node.invalidate();
                return info;
            }
        }
        throw new IllegalStateException("No handler accepted artifacts " + artifacts);
    }

    private void assertMounted() throws RepositoryException {
        if (!this.isMounted()) {
            throw new RepositoryException("JcrFS is not mounted anymore.");
        }
    }

    @Override
    public boolean isMounted() {
        return this.session != null && this.session.isLive();
    }

    @Override
    public String getUserId() throws RepositoryException {
        this.assertMounted();
        return this.session.getUserID();
    }

    @Override
    public String getWorkspace() throws RepositoryException {
        this.assertMounted();
        return this.session.getWorkspace().getName();
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void dumpConfig(PrintWriter out) throws IOException {
        DumpContext ctx = new DumpContext(out);
        ctx.println(false, "workspace filter");
        ctx.indent(false);
        this.workspaceFilter.dump(ctx, true);
        ctx.outdent();
        this.aggregatorProvider.dump(ctx, false);
        ctx.println(true, "handlers");
        ctx.indent(true);
        Iterator<ArtifactHandler> iter = this.artifactHandlers.iterator();
        while (iter.hasNext()) {
            ArtifactHandler h = iter.next();
            h.dump(ctx, !iter.hasNext());
        }
        ctx.outdent();
        ctx.flush();
    }

    @Override
    public VaultFsConfig getConfig() {
        return this.config;
    }

    private static class AggregatorTracker {
        private static final Logger log = LoggerFactory.getLogger(AggregatorTracker.class);
        private ProgressTrackerListener tracker;
        int numCreated;
        int numCollected;
        int numPrepared;
        long lastLogged;

        private AggregatorTracker(ProgressTrackerListener tracker) {
            this.tracker = tracker;
        }

        public void onCreated() {
            ++this.numCreated;
            this.log(false);
        }

        public void onCollected() {
            ++this.numCollected;
            this.log(false);
        }

        public void onPrepared() {
            ++this.numPrepared;
            this.log(false);
        }

        public void log(boolean flush) {
            if (this.tracker == null && !log.isInfoEnabled()) {
                return;
            }
            long now = System.currentTimeMillis();
            if (this.lastLogged == 0L) {
                this.lastLogged = now;
            } else if (now - this.lastLogged > 5000L || flush) {
                this.lastLogged = now;
                String str = "Aggregation status: " + this.numPrepared + " of " + this.numCreated + " prepared, " + this.numCollected + " collected";
                log.debug("- {}", (Object)str);
                if (this.tracker != null) {
                    this.tracker.onMessage(ProgressTrackerListener.Mode.TEXT, "-", str);
                }
            }
        }
    }
}

