/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.fs.api.VaultFileOutput;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.fs.impl.TransactionImpl;
import org.apache.jackrabbit.vault.util.FileInputSource;

public class VaultFileOutputImpl
implements VaultFileOutput {
    private final TransactionImpl.Change tx;
    private OutputStream out;
    private File tmpFile;
    private VaultInputSource is;

    protected VaultFileOutputImpl(TransactionImpl.Change tx) {
        this.tx = tx;
    }

    protected VaultFileOutputImpl(TransactionImpl.Change tx, VaultInputSource input) {
        this.tx = tx;
        this.is = input;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.out != null) {
            throw new IOException("Output stream already obtained.");
        }
        this.tmpFile = File.createTempFile("vltfs", ".tmp");
        this.tmpFile.deleteOnExit();
        this.out = new FileOutputStream(this.tmpFile);
        return this.out;
    }

    public void setContentType(String contentType) {
        this.tx.setContentType(contentType);
    }

    public void close() throws IOException, RepositoryException {
        if (this.out != null) {
            this.out.close();
            this.is = new FileInputSource(this.tmpFile);
            this.tx.setInputSource(this.is);
        }
    }
}

