/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl;

import java.io.IOException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.fs.api.Aggregate;
import org.apache.jackrabbit.vault.fs.api.AggregateManager;
import org.apache.jackrabbit.vault.fs.api.VaultFile;
import org.apache.jackrabbit.vault.fs.api.VaultFileSystem;
import org.apache.jackrabbit.vault.fs.api.VaultFsConfig;
import org.apache.jackrabbit.vault.fs.api.VaultFsTransaction;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.impl.AggregateImpl;
import org.apache.jackrabbit.vault.fs.impl.TransactionImpl;
import org.apache.jackrabbit.vault.fs.impl.VaultFileImpl;
import org.apache.jackrabbit.vault.fs.impl.VaultFileNode;
import org.apache.jackrabbit.vault.util.PathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaultFileSystemImpl
implements VaultFileSystem {
    private static Logger log = LoggerFactory.getLogger(VaultFileSystemImpl.class);
    private AggregateManager mgr;
    private boolean isOwnManager;
    private VaultFileImpl root;
    private final String rootPath;
    private final String rootPattern;

    public void unmount() throws RepositoryException {
        this.assertMounted();
        if (this.isOwnManager) {
            this.mgr.unmount();
        }
        this.mgr = null;
        this.root = null;
    }

    private void assertMounted() throws RepositoryException {
        if (!this.isMounted()) {
            throw new RepositoryException("JcrFS is not mounted anymore.");
        }
    }

    public boolean isMounted() {
        return this.mgr != null && this.mgr.isMounted();
    }

    public VaultFileSystemImpl(Aggregate rootAggregate, String rootPath, boolean ownMgr) throws IOException, RepositoryException {
        if (!rootAggregate.allowsChildren()) {
            throw new IOException("Root node must allow children.");
        }
        this.mgr = rootAggregate.getManager();
        this.isOwnManager = ownMgr;
        VaultFileNode rootFileNode = new VaultFileNode(null, (AggregateImpl)rootAggregate);
        this.rootPath = rootPath == null || rootPath.equals("/") ? "" : rootPath;
        this.rootPattern = this.rootPath + "/";
        this.root = new VaultFileImpl(this, this.rootPath, rootFileNode);
    }

    public VaultFile getRoot() {
        return this.root;
    }

    public AggregateManager getAggregateManager() {
        return this.mgr;
    }

    public VaultFile getFile(String path) throws IOException, RepositoryException {
        if (path.charAt(0) != '/') {
            throw new IOException("Only absolute paths allowed");
        }
        if (this.rootPath.length() > 0) {
            if (!path.equals(this.rootPath) && !path.startsWith(this.rootPattern)) {
                throw new IOException("Path not under mountpoint.");
            }
            path = path.substring(this.rootPath.length());
        }
        return this.getFile(this.root, path);
    }

    public VaultFile getFile(VaultFile parent, String path) throws IOException, RepositoryException {
        if (path == null || path.equals("") || path.equals(".")) {
            return parent;
        }
        if (path.equals("/")) {
            return this.getRoot();
        }
        String[] pathElems = PathUtil.makePath((String[])null, path);
        for (int i = 0; i < pathElems.length && parent != null; ++i) {
            String elem = pathElems[i];
            parent = elem.equals("/") ? this.getRoot() : (elem.equals("..") ? parent.getParent() : parent.getChild(elem));
        }
        return parent;
    }

    public VaultFsTransaction startTransaction() {
        return new TransactionImpl(this);
    }

    public void invalidate() throws RepositoryException {
        AggregateImpl rootAggregate = (AggregateImpl)this.root.getAggregate();
        rootAggregate.invalidate();
        VaultFileNode rootFileNode = new VaultFileNode(null, rootAggregate);
        this.root = new VaultFileImpl(this, this.rootPath, rootFileNode);
        log.info("Filesystem invalidated.");
    }

    public VaultFsConfig getConfig() {
        return this.mgr.getConfig();
    }

    public WorkspaceFilter getWorkspaceFilter() {
        return this.mgr.getWorkspaceFilter();
    }
}

