/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.aggregator;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.fs.api.ArtifactType;
import org.apache.jackrabbit.vault.fs.api.DumpContext;
import org.apache.jackrabbit.vault.fs.api.ImportInfo;
import org.apache.jackrabbit.vault.fs.filter.NodeTypeItemFilter;
import org.apache.jackrabbit.vault.fs.impl.AggregateImpl;
import org.apache.jackrabbit.vault.fs.impl.ArtifactSetImpl;
import org.apache.jackrabbit.vault.fs.impl.aggregator.GenericAggregator;
import org.apache.jackrabbit.vault.fs.impl.io.CNDSerializer;
import org.apache.jackrabbit.vault.fs.impl.io.ImportInfoImpl;

public class NodeTypeAggregator
extends GenericAggregator {
    public boolean hasFullCoverage() {
        return true;
    }

    public boolean matches(Node node, String path) throws RepositoryException {
        if (this.getMatchFilter().isEmpty()) {
            this.getMatchFilter().addInclude(new NodeTypeItemFilter("nt:nodeType", true));
        }
        return super.matches(node, path);
    }

    public ArtifactSetImpl createArtifacts(AggregateImpl aggregate) throws RepositoryException {
        ArtifactSetImpl artifacts = new ArtifactSetImpl();
        CNDSerializer ser = new CNDSerializer(aggregate);
        artifacts.add(null, aggregate.getRelPath(), ".xcnd", ArtifactType.PRIMARY, ser, 0L);
        return artifacts;
    }

    public ImportInfo remove(Node node, boolean recursive, boolean trySave) throws RepositoryException {
        ImportInfoImpl info = new ImportInfoImpl();
        info.onDeleted(node.getPath());
        Node parent = node.getParent();
        node.remove();
        if (trySave) {
            parent.save();
        }
        return info;
    }

    public void dump(DumpContext ctx, boolean isLast) {
        ctx.println(isLast, this.getClass().getSimpleName());
    }
}

