/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.fs.api.Aggregate;
import org.apache.jackrabbit.vault.fs.api.ArtifactHandler;
import org.apache.jackrabbit.vault.fs.api.ArtifactSet;
import org.apache.jackrabbit.vault.fs.api.DumpContext;
import org.apache.jackrabbit.vault.fs.api.Dumpable;
import org.apache.jackrabbit.vault.fs.api.ImportInfo;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.impl.ArtifactSetImpl;
import org.apache.jackrabbit.vault.fs.impl.io.ImportInfoImpl;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.fs.spi.ACLManagement;
import org.apache.jackrabbit.vault.fs.spi.ServiceProviderFactory;

public abstract class AbstractArtifactHandler
implements ArtifactHandler,
Dumpable {
    protected AccessControlHandling acHandling = AccessControlHandling.OVERWRITE;
    private ACLManagement aclManagement;

    public AccessControlHandling getAcHandling() {
        return this.acHandling;
    }

    public void setAcHandling(AccessControlHandling acHandling) {
        this.acHandling = acHandling;
    }

    public ACLManagement getAclManagement() {
        if (this.aclManagement == null) {
            this.aclManagement = ServiceProviderFactory.getProvider().getACLManagement();
        }
        return this.aclManagement;
    }

    public ImportInfo accept(Session session, Aggregate file, ArtifactSet artifacts) throws RepositoryException, IOException {
        Node node = file.getNode();
        String name = node.getName();
        return this.accept(file.getManager().getWorkspaceFilter(), name.length() == 0 ? node : node.getParent(), name, (ArtifactSetImpl)artifacts);
    }

    public ImportInfo accept(Session session, Aggregate parent, String name, ArtifactSet artifacts) throws RepositoryException, IOException {
        Node node = parent.getNode();
        return this.accept(parent.getManager().getWorkspaceFilter(), node, name, (ArtifactSetImpl)artifacts);
    }

    protected abstract ImportInfoImpl accept(WorkspaceFilter var1, Node var2, String var3, ArtifactSetImpl var4) throws RepositoryException, IOException;

    public void dump(DumpContext ctx, boolean isLast) {
        ctx.println(isLast, this.getClass().getSimpleName());
    }
}

