/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.vault.fs.impl.io.AggregateWalkListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentAnalyzer
implements AggregateWalkListener {
    private final HashMap<String, String> namespaces = new HashMap();
    private final List<Property> binaries = new LinkedList<Property>();
    private final List<String> ignoredPaths = new LinkedList<String>();
    private boolean isEmpty = true;

    public String[] getNamespaceURIs() {
        return this.namespaces.keySet().toArray(new String[this.namespaces.keySet().size()]);
    }

    public String getNamespacePrefix(String uri) {
        return this.namespaces.get(uri);
    }

    public Collection<Property> getBinaries() {
        return this.binaries;
    }

    public Collection<String> getIgnoredPaths() {
        return this.ignoredPaths;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public void onNodeBegin(Node node, boolean included, int depth) throws RepositoryException {
        if (included) {
            this.isEmpty = false;
        }
        this.addNamespace(node.getSession(), node.getName());
    }

    @Override
    public void onNodeEnd(Node node, boolean included, int depth) throws RepositoryException {
    }

    @Override
    public void onProperty(Property prop, int depth) throws RepositoryException {
        this.isEmpty = false;
        this.addNamespace(prop.getSession(), prop.getName());
        switch (prop.getType()) {
            case 2: {
                this.binaries.add(prop);
                break;
            }
            case 7: {
                if (prop.getDefinition().isMultiple()) {
                    Value[] values;
                    for (Value value : values = prop.getValues()) {
                        this.addNamespace(prop.getSession(), value.getString());
                    }
                    break;
                }
                this.addNamespace(prop.getSession(), prop.getValue().getString());
                break;
            }
            case 8: {
                if (prop.getDefinition().isMultiple()) {
                    Value[] values;
                    for (Value value : values = prop.getValues()) {
                        this.addNamespacePath(prop.getSession(), value.getString());
                    }
                    break;
                }
                this.addNamespacePath(prop.getSession(), prop.getValue().getString());
            }
        }
    }

    @Override
    public void onNodeIgnored(Node node, int depth) throws RepositoryException {
        this.ignoredPaths.add(node.getPath());
    }

    @Override
    public void onWalkBegin(Node root) throws RepositoryException {
    }

    @Override
    public void onChildren(Node node, int depth) throws RepositoryException {
    }

    @Override
    public void onWalkEnd(Node root) throws RepositoryException {
    }

    private void addNamespace(Session s, String name) throws RepositoryException {
        int idx = name.indexOf(58);
        if (idx > 0) {
            String prefix = name.substring(0, idx);
            String uri = s.getNamespaceURI(prefix);
            this.namespaces.put(uri, prefix);
        }
    }

    private void addNamespacePath(Session s, String path) throws RepositoryException {
        String[] names;
        for (String name : names = path.split("/")) {
            this.addNamespace(s, name);
        }
    }
}

