/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.fs.api.Aggregate;
import org.apache.jackrabbit.vault.fs.api.SerializationType;
import org.apache.jackrabbit.vault.fs.impl.AggregateImpl;
import org.apache.jackrabbit.vault.fs.impl.io.DocViewSAXFormatter;
import org.apache.jackrabbit.vault.fs.io.Serializer;
import org.apache.jackrabbit.vault.util.xml.serialize.OutputFormat;
import org.apache.jackrabbit.vault.util.xml.serialize.XMLSerializer;

public class DocViewSerializer
implements Serializer {
    private final AggregateImpl aggregate;

    public DocViewSerializer(Aggregate aggregate) {
        this.aggregate = (AggregateImpl)aggregate;
    }

    public void writeContent(OutputStream out) throws IOException, RepositoryException {
        OutputFormat oFmt = new OutputFormat("xml", "UTF-8", true);
        oFmt.setIndent(4);
        oFmt.setLineWidth(0);
        oFmt.setBreakEachAttribute(true);
        XMLSerializer ser = new XMLSerializer(out, oFmt);
        DocViewSAXFormatter fmt = new DocViewSAXFormatter(this.aggregate, ser);
        fmt.setUseJcrRoot(true);
        this.aggregate.walk(fmt);
    }

    public SerializationType getType() {
        return SerializationType.XML_DOCVIEW;
    }
}

