/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import org.apache.jackrabbit.vault.fs.api.ImportInfo;
import org.apache.jackrabbit.vault.fs.api.NodeNameList;
import org.apache.jackrabbit.vault.util.PathComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportInfoImpl
implements ImportInfo {
    static final Logger log = LoggerFactory.getLogger(ImportInfoImpl.class);
    private final TreeMap<String, ImportInfo.Info> infos = new TreeMap(new PathComparator());
    private Map<String, String> remapped;
    private final Set<String> toVersion = new LinkedHashSet<String>();
    private int numModified;
    private int numErrors;
    private Map<String, String[]> memberships;

    public static ImportInfo create(ImportInfo base) {
        if (base == null) {
            return new ImportInfoImpl();
        }
        return base;
    }

    @Override
    public ImportInfoImpl merge(ImportInfo base) {
        if (base instanceof ImportInfoImpl) {
            ImportInfoImpl baseImpl = (ImportInfoImpl)base;
            this.infos.putAll(baseImpl.infos);
            this.numModified += baseImpl.numModified;
            this.numErrors += baseImpl.numErrors;
            this.toVersion.addAll(baseImpl.toVersion);
            if (this.remapped == null) {
                this.remapped = baseImpl.remapped;
            } else {
                this.remapped.putAll(baseImpl.getRemapped());
            }
            if (this.memberships == null) {
                this.memberships = baseImpl.memberships;
            } else {
                this.memberships.putAll(baseImpl.getMemberships());
            }
        }
        return this;
    }

    @Override
    public TreeMap<String, ImportInfo.Info> getInfos() {
        return this.infos;
    }

    @Override
    public ImportInfo.Info getInfo(String path) {
        return this.infos.get(path);
    }

    @Override
    @Deprecated
    public NodeNameList getNameList() {
        return this.infos.isEmpty() ? null : this.infos.firstEntry().getValue().getNameList();
    }

    private InfoImpl getOrCreateInfo(String path) {
        InfoImpl info = (InfoImpl)this.infos.get(path);
        if (info == null) {
            info = new InfoImpl(path);
            this.infos.put(path, info);
        }
        return info;
    }

    public void addNameList(String path, NodeNameList nameList) {
        this.getOrCreateInfo(path).nameList = nameList;
    }

    @Override
    public void onModified(String path) {
        ImportInfo.Type prev = this.getOrCreateInfo(path).type;
        if (prev == null || prev != ImportInfo.Type.CRE) {
            this.addMod(path, ImportInfo.Type.MOD, null);
        }
    }

    @Override
    public void onNop(String path) {
        this.getOrCreateInfo(path);
    }

    @Override
    public void onCreated(String path) {
        this.addMod(path, ImportInfo.Type.CRE, null);
    }

    @Override
    public void onDeleted(String path) {
        this.addMod(path, ImportInfo.Type.DEL, null);
    }

    @Override
    public void onReplaced(String path) {
        this.addMod(path, ImportInfo.Type.REP, null);
    }

    @Override
    public void onMissing(String path) {
        this.addMod(path, ImportInfo.Type.MIS, null);
    }

    @Override
    public void onError(String path, Exception e) {
        this.addMod(path, ImportInfo.Type.ERR, e);
        ++this.numErrors;
    }

    public void onRemapped(String oldPath, String newPath) {
        if (this.remapped == null) {
            this.remapped = new HashMap<String, String>();
        }
        this.remapped.put(oldPath, newPath);
    }

    public Map<String, String> getRemapped() {
        return this.remapped == null ? Collections.emptyMap() : this.remapped;
    }

    private void addMod(String path, ImportInfo.Type mod, Exception e) {
        InfoImpl info = this.getOrCreateInfo(path);
        if (info.type != ImportInfo.Type.ERR) {
            info.type = mod;
            info.error = e;
        }
        if (mod != ImportInfo.Type.NOP) {
            ++this.numModified;
        }
        log.debug("{} {}", (Object)mod, (Object)path);
    }

    @Override
    public TreeMap<String, ImportInfo.Type> getModifications() {
        TreeMap<String, ImportInfo.Type> mods = new TreeMap<String, ImportInfo.Type>();
        for (Map.Entry<String, ImportInfo.Info> e : this.infos.entrySet()) {
            ImportInfo.Type mod = e.getValue().getType();
            if (mod == null) continue;
            mods.put(e.getKey(), mod);
        }
        return mods;
    }

    @Override
    @Deprecated
    public Exception getError(String path) {
        ImportInfo.Info info = this.infos.get(path);
        return info == null ? null : info.getError();
    }

    @Override
    public Collection<String> getToVersion() {
        return this.toVersion;
    }

    public void registerToVersion(String path) {
        this.toVersion.add(path);
    }

    public void checkinNodes(Session session) {
        Iterator<String> iter = this.toVersion.iterator();
        while (iter.hasNext()) {
            String path = iter.next();
            iter.remove();
            try {
                Node node = session.getNode(path);
                if (!node.isNodeType("mix:versionable")) continue;
                try {
                    Version v = node.checkin();
                    log.info("Checked in versionable node {} (v={})", (Object)path, (Object)v.getName());
                }
                catch (RepositoryException e) {
                    log.error("Error while checkin node {}: {}", (Object)path, (Object)e.toString());
                }
            }
            catch (RepositoryException e) {
                log.error("Error while retrieving node to be versioned at {}.", (Object)path, (Object)e);
            }
        }
    }

    @Override
    public int numModified() {
        return this.numModified;
    }

    @Override
    public int numErrors() {
        return this.numErrors;
    }

    public void registerMemberships(String id, String[] members) {
        if (this.memberships == null) {
            this.memberships = new HashMap<String, String[]>();
        }
        this.memberships.put(id, members);
    }

    @Override
    public Map<String, String[]> getMemberships() {
        return this.memberships == null ? Collections.emptyMap() : this.memberships;
    }

    static final class InfoImpl
    implements ImportInfo.Info {
        private final String path;
        private ImportInfo.Type type = ImportInfo.Type.NOP;
        private NodeNameList nameList;
        private Exception error;

        InfoImpl(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public ImportInfo.Type getType() {
            return this.type;
        }

        public NodeNameList getNameList() {
            return this.nameList;
        }

        public Exception getError() {
            return this.error;
        }
    }
}

