/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.vault.fs.impl.io.DocViewAdapter;
import org.apache.jackrabbit.vault.fs.impl.io.DocViewSAXImporter;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.util.DocViewNode;
import org.apache.jackrabbit.vault.util.DocViewProperty;
import org.slf4j.Logger;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JackrabbitACLImporter
implements DocViewAdapter {
    private static final Logger log = DocViewSAXImporter.log;
    private final JackrabbitSession session;
    private final AccessControlHandling aclHandling;
    private final AccessControlManager acMgr;
    private final PrincipalManager pMgr;
    private final String accessControlledPath;
    private Map<String, List<ACE>> aceMap = new LinkedHashMap<String, List<ACE>>();
    private ACE currentACE;
    private final Stack<State> states = new Stack();

    public JackrabbitACLImporter(Node accessControlledNode, AccessControlHandling aclHandling) throws RepositoryException {
        this(accessControlledNode.getSession(), accessControlledNode.getPath(), aclHandling);
    }

    public JackrabbitACLImporter(Session session, AccessControlHandling aclHandling) throws RepositoryException {
        this(session, null, aclHandling);
    }

    private JackrabbitACLImporter(Session session, String path, AccessControlHandling aclHandling) throws RepositoryException {
        if (aclHandling == AccessControlHandling.CLEAR || aclHandling == AccessControlHandling.IGNORE) {
            throw new RepositoryException("Error while reading access control content: unsupported AccessControlHandling: " + (Object)((Object)aclHandling));
        }
        this.accessControlledPath = path;
        this.session = (JackrabbitSession)session;
        this.acMgr = this.session.getAccessControlManager();
        this.pMgr = this.session.getPrincipalManager();
        this.aclHandling = aclHandling;
        this.states.push(State.INITIAL);
    }

    @Override
    public void startNode(DocViewNode node) throws SAXException {
        State state = this.states.peek();
        switch (state) {
            case INITIAL: {
                if ("rep:ACL".equals(node.primary)) {
                    state = State.ACL;
                    break;
                }
                log.error("Error while reading access control content: Expected rep:ACL but was: {}", (Object)node.primary);
                state = State.ERROR;
                break;
            }
            case ACL: {
                try {
                    this.currentACE = JackrabbitACLImporter.addACE(this.aceMap, new ACE(node));
                    state = State.ACE;
                }
                catch (IllegalArgumentException e) {
                    log.error("Error while reading access control content: {}", (Throwable)e);
                    state = State.ERROR;
                }
                break;
            }
            case ACE: {
                this.currentACE.addRestrictions(node);
                state = State.RESTRICTION;
                break;
            }
            case RESTRICTION: {
                log.error("Error while reading access control content: Unexpected node: {} for state {}", (Object)node.primary, (Object)state);
                state = State.ERROR;
                break;
            }
        }
        this.states.push(state);
    }

    private static ACE addACE(Map<String, List<ACE>> map, ACE ace) {
        List<ACE> list = map.get(ace.principalName);
        if (list == null) {
            list = new ArrayList<ACE>();
            map.put(ace.principalName, list);
        }
        list.add(ace);
        return ace;
    }

    @Override
    public void endNode() throws SAXException {
        State state = this.states.pop();
        if (state == State.ACE) {
            this.currentACE = null;
        }
    }

    @Override
    public void close() throws SAXException {
        if (this.states.peek() != State.INITIAL) {
            log.error("Unexpected end state: {}", (Object)this.states.peek());
        }
        try {
            this.apply();
        }
        catch (RepositoryException e) {
            log.error("Error while applying access control content.", (Throwable)e);
        }
    }

    private void apply() throws RepositoryException {
        ValueFactory valueFactory = this.session.getValueFactory();
        JackrabbitAccessControlList acl = null;
        HashSet<String> existingPrincipals = new HashSet<String>();
        for (AccessControlPolicy p : this.acMgr.getPolicies(this.accessControlledPath)) {
            if (!(p instanceof JackrabbitAccessControlList)) continue;
            acl = (JackrabbitAccessControlList)p;
            for (AccessControlEntry ace : acl.getAccessControlEntries()) {
                existingPrincipals.add(ace.getPrincipal().getName());
            }
        }
        if (this.aclHandling == AccessControlHandling.OVERWRITE && acl != null) {
            this.acMgr.removePolicy(this.accessControlledPath, (AccessControlPolicy)acl);
            acl = null;
        }
        if (acl == null) {
            AccessControlPolicyIterator iter = this.acMgr.getApplicablePolicies(this.accessControlledPath);
            while (iter.hasNext()) {
                AccessControlPolicy p = iter.nextAccessControlPolicy();
                if (!(p instanceof JackrabbitAccessControlList)) continue;
                acl = (JackrabbitAccessControlList)p;
                break;
            }
        }
        if (acl == null) {
            throw new RepositoryException("not JackrabbitAccessControlList applicable on " + (this.accessControlledPath == null ? "'root'" : this.accessControlledPath));
        }
        for (Map.Entry<String, List<ACE>> entry : this.aceMap.entrySet()) {
            final String principalName = entry.getKey();
            if (this.aclHandling == AccessControlHandling.MERGE_PRESERVE && existingPrincipals.contains(principalName)) continue;
            Principal principal = this.pMgr.getPrincipal(principalName);
            if (principal == null) {
                principal = new Principal(){

                    public String getName() {
                        return principalName;
                    }
                };
            }
            for (ACE ace : entry.getValue()) {
                Privilege[] privileges = new Privilege[ace.privileges.length];
                for (int i = 0; i < privileges.length; ++i) {
                    privileges[i] = this.acMgr.privilegeFromName(ace.privileges[i]);
                }
                HashMap<String, Value> svRestrictions = new HashMap<String, Value>();
                HashMap<String, Value[]> mvRestrictions = new HashMap<String, Value[]>();
                for (String restName : acl.getRestrictionNames()) {
                    DocViewProperty restriction = (DocViewProperty)ace.restrictions.get(restName);
                    if (restriction == null) continue;
                    Value[] values = new Value[restriction.values.length];
                    int type = acl.getRestrictionType(restName);
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = valueFactory.createValue(restriction.values[i], type);
                    }
                    if (restriction.isMulti) {
                        mvRestrictions.put(restName, values);
                        continue;
                    }
                    svRestrictions.put(restName, values[0]);
                }
                acl.addEntry(principal, privileges, ace.allow, svRestrictions, mvRestrictions);
            }
        }
        this.acMgr.setPolicy(this.accessControlledPath, (AccessControlPolicy)acl);
    }

    private static class ACE {
        private final boolean allow;
        private final String principalName;
        private final String[] privileges;
        private final Map<String, DocViewProperty> restrictions = new HashMap<String, DocViewProperty>();

        private ACE(DocViewNode node) {
            if ("rep:GrantACE".equals(node.primary)) {
                this.allow = true;
            } else if ("rep:DenyACE".equals(node.primary)) {
                this.allow = false;
            } else {
                throw new IllegalArgumentException("Unexpected node ACE type: " + node.primary);
            }
            this.principalName = node.getValue("rep:principalName");
            this.privileges = node.getValues("rep:privileges");
            this.addRestrictions(node);
        }

        public void addRestrictions(DocViewNode node) {
            this.restrictions.putAll(node.props);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        INITIAL,
        ACL,
        ACE,
        RESTRICTION,
        ERROR;

    }
}

