/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import javax.jcr.Node;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.fs.impl.io.DocViewAdapter;
import org.apache.jackrabbit.vault.fs.impl.io.DocViewSAXImporter;
import org.apache.jackrabbit.vault.util.DocViewNode;
import org.apache.jackrabbit.vault.util.DocViewProperty;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class JcrSysViewTransformer
implements DocViewAdapter {
    private ContentHandler handler;

    JcrSysViewTransformer(Node node) throws RepositoryException, SAXException {
        Session session = node.getSession();
        this.handler = session.getImportContentHandler(node.getPath(), 1);
        String[] prefixes = session.getNamespacePrefixes();
        this.handler.startDocument();
        for (String prefix : prefixes) {
            this.handler.startPrefixMapping(prefix, session.getNamespaceURI(prefix));
        }
    }

    public void close() throws SAXException {
        this.handler.endDocument();
    }

    public void startNode(DocViewNode ni) throws SAXException {
        DocViewSAXImporter.log.debug("Transforming element to sysview {}", (Object)ni.name);
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "name", "sv:name", "CDATA", ni.name);
        this.handler.startElement("http://www.jcp.org/jcr/sv/1.0", "node", "sv:node", attrs);
        for (DocViewProperty p : ni.props.values()) {
            if (p == null || p.values == null) continue;
            attrs = new AttributesImpl();
            attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "name", "sv:name", "CDATA", p.name);
            attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "type", "sv:type", "CDATA", PropertyType.nameFromValue((int)p.type));
            this.handler.startElement("http://www.jcp.org/jcr/sv/1.0", "property", "sv:property", attrs);
            for (String v : p.values) {
                this.handler.startElement("http://www.jcp.org/jcr/sv/1.0", "value", "sv:value", DocViewSAXImporter.EMPTY_ATTRIBUTES);
                this.handler.characters(v.toCharArray(), 0, v.length());
                this.handler.endElement("http://www.jcp.org/jcr/sv/1.0", "value", "sv:value");
            }
            this.handler.endElement("http://www.jcp.org/jcr/sv/1.0", "property", "sv:property");
        }
    }

    public void endNode() throws SAXException {
        this.handler.endElement("http://www.jcp.org/jcr/sv/1.0", "node", "sv:node");
    }
}

