/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.packaging.PackageId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubPackageHandling {
    public static final SubPackageHandling DEFAULT = new SubPackageHandling(Collections.<Entry>emptyList());
    private final List<Entry> entries;

    public SubPackageHandling() {
        this(new LinkedList<Entry>());
    }

    private SubPackageHandling(List<Entry> entries) {
        this.entries = entries;
    }

    public static SubPackageHandling fromString(String str) {
        if (str == null || str.isEmpty()) {
            return DEFAULT;
        }
        SubPackageHandling sp = new SubPackageHandling();
        for (String instruction : Text.explode((String)str, (int)44)) {
            String[] opts = Text.explode((String)instruction.trim(), (int)59);
            if (opts.length <= 0) continue;
            PackageId id = PackageId.fromString(opts[0]);
            Option opt = Option.INSTALL;
            if (opts.length > 1) {
                try {
                    opt = Option.valueOf(opts[1].toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            sp.getEntries().add(new Entry(id.getGroup(), id.getName(), opt));
        }
        return sp;
    }

    public Option getOption(PackageId id) {
        Option opt = null;
        for (Entry e : this.entries) {
            if (!"*".equals(e.groupName) && !id.getGroup().equals(e.groupName) || !"*".equals(e.packageName) && !id.getName().equals(e.packageName)) continue;
            opt = e.option;
        }
        return opt == null ? Option.INSTALL : opt;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public String getString() {
        StringBuilder sb = new StringBuilder();
        for (Entry e : this.entries) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(e.getGroupName()).append(":").append(e.getPackageName());
            if (e.option == Option.INSTALL) continue;
            sb.append(';').append(e.option.toString().toLowerCase());
        }
        return sb.toString();
    }

    public static class Entry {
        private final String groupName;
        private final String packageName;
        private final Option option;

        public Entry(String groupName, String packageName, Option option) {
            this.groupName = groupName == null || groupName.isEmpty() ? "*" : groupName;
            this.packageName = packageName == null || packageName.isEmpty() ? "*" : packageName;
            this.option = option;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public Option getOption() {
            return this.option;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        INSTALL,
        EXTRACT,
        ADD,
        IGNORE;

    }
}

