/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.fs.io.MemoryArchive;
import org.apache.jackrabbit.vault.packaging.CyclicDependencyException;
import org.apache.jackrabbit.vault.packaging.DependencyUtil;
import org.apache.jackrabbit.vault.packaging.ExportOptions;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.SubPackageHandling;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.jackrabbit.vault.packaging.impl.InstallContextImpl;
import org.apache.jackrabbit.vault.packaging.impl.JcrPackageDefinitionImpl;
import org.apache.jackrabbit.vault.packaging.impl.JcrPackageManagerImpl;
import org.apache.jackrabbit.vault.packaging.impl.ZipVaultPackage;
import org.apache.jackrabbit.vault.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrPackageImpl
implements JcrPackage {
    private static final Logger log = LoggerFactory.getLogger(JcrPackageImpl.class);
    private Node node;
    private ZipVaultPackage pack;
    private JcrPackageDefinitionImpl def;

    public JcrPackageImpl(Node node) throws RepositoryException {
        this.node = node;
    }

    protected JcrPackageImpl(Node node, ZipVaultPackage pack) throws RepositoryException {
        this.node = node;
        this.pack = pack;
    }

    protected JcrPackageImpl(Node node, ZipVaultPackage pack, JcrPackageDefinitionImpl def) throws RepositoryException {
        this.node = node;
        this.pack = pack;
        this.def = def;
    }

    public JcrPackageDefinition getDefinition() throws RepositoryException {
        if (this.def == null && this.isValid()) {
            Node defNode = this.getDefNode();
            this.def = defNode == null ? null : new JcrPackageDefinitionImpl(defNode);
        }
        return this.def;
    }

    public int compareTo(JcrPackage o) {
        try {
            JcrPackageDefinition d1 = this.getDefinition();
            JcrPackageDefinition d2 = o.getDefinition();
            return d1.getId().compareTo(d2.getId());
        }
        catch (Exception e) {
            log.error("error during compare: {}", (Object)e.toString());
            return 0;
        }
    }

    public boolean isValid() {
        try {
            if (this.node != null && this.node.isNodeType("nt:hierarchyNode") && this.node.hasNode("jcr:content") && this.node.getNode("jcr:content").isNodeType("vlt:Package")) {
                return true;
            }
        }
        catch (RepositoryException e) {
            log.warn("Error during evaluation of isValid()", (Throwable)e);
        }
        return false;
    }

    public boolean isInstalled() throws RepositoryException {
        JcrPackageDefinition def = this.getDefinition();
        return def != null && def.getLastUnpacked() != null;
    }

    public Node getNode() {
        return this.node;
    }

    public boolean isSealed() {
        try {
            if (!this.isValid()) {
                return false;
            }
            if (this.getSize() == 0L) {
                return false;
            }
            if (this.getDefinition() == null) {
                return true;
            }
            return !this.def.isModified();
        }
        catch (RepositoryException e) {
            log.warn("Error during isSealed()", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JcrPackage createNew(Node parent, PackageId pid, VaultPackage pack, boolean autoSave) throws RepositoryException, IOException {
        Node node = parent.addNode(Text.getName(pid.getInstallationPath() + ".zip"), "nt:file");
        Node content = node.addNode("jcr:content", "nt:resource");
        content.addMixin("vlt:Package");
        Node defNode = content.addNode("vlt:definition");
        JcrPackageDefinitionImpl def = new JcrPackageDefinitionImpl(defNode);
        def.set("name", pid.getName(), false);
        def.set("group", pid.getGroup(), false);
        def.set("version", pid.getVersionString(), false);
        def.touch(null, false);
        content.setProperty("jcr:lastModified", Calendar.getInstance());
        content.setProperty("jcr:mimeType", "application/zip");
        InputStream in = new ByteArrayInputStream(new byte[0]);
        try {
            if (pack != null && pack.getFile() != null) {
                in = FileUtils.openInputStream((File)pack.getFile());
            }
            content.setProperty("jcr:data", in);
            if (pack != null) {
                def.unwrap(pack, true, false);
            }
            if (autoSave) {
                parent.save();
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return new JcrPackageImpl(node, (ZipVaultPackage)pack);
    }

    public static JcrPackage createNew(Node parent, PackageId pid, Binary bin, MemoryArchive archive) throws RepositoryException, IOException {
        Node node = parent.addNode(Text.getName(pid.getInstallationPath() + ".zip"), "nt:file");
        Node content = node.addNode("jcr:content", "nt:resource");
        content.addMixin("vlt:Package");
        Node defNode = content.addNode("vlt:definition");
        JcrPackageDefinitionImpl def = new JcrPackageDefinitionImpl(defNode);
        def.set("name", pid.getName(), false);
        def.set("group", pid.getGroup(), false);
        def.set("version", pid.getVersionString(), false);
        def.touch(null, false);
        content.setProperty("jcr:lastModified", Calendar.getInstance());
        content.setProperty("jcr:mimeType", "application/zip");
        content.setProperty("jcr:data", bin);
        def.unwrap(archive, false);
        return new JcrPackageImpl(node);
    }

    public boolean verifyId(boolean autoFix, boolean autoSave) throws RepositoryException {
        JcrPackageDefinition jDef = this.getDefinition();
        if (jDef == null) {
            return true;
        }
        PackageId id = jDef.getId();
        PackageId cId = new PackageId(this.node.getPath());
        if (id.getInstallationPath().equals(cId.getInstallationPath())) {
            if (autoFix && id.isFromPath()) {
                jDef.setId(cId, autoSave);
            }
            return true;
        }
        if (autoFix) {
            log.warn("Fixing non-matching id from {} to {}.", (Object)id, (Object)cId);
            jDef.setId(cId, autoSave);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryUnwrap() throws IOException, RepositoryException {
        if (this.isValid()) {
            return;
        }
        VaultPackage pack = this.getPackage();
        Node content = this.getContent();
        boolean ok = false;
        try {
            content.addMixin("vlt:Package");
            Node defNode = content.addNode("vlt:definition");
            JcrPackageDefinitionImpl def = new JcrPackageDefinitionImpl(defNode);
            def.unwrap(pack, true, false);
            this.node.save();
            ok = true;
        }
        finally {
            if (!ok) {
                try {
                    this.node.refresh(false);
                }
                catch (RepositoryException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VaultPackage getPackage() throws RepositoryException, IOException {
        if (this.pack == null) {
            long size = -1L;
            try {
                size = this.getData().getLength();
            }
            catch (RepositoryException e) {
                // empty catch block
            }
            if (size >= 0L && size < 0x100000L) {
                MemoryArchive archive = new MemoryArchive(false);
                InputStream in = this.getData().getStream();
                try {
                    archive.run(in);
                }
                catch (Exception e) {
                    throw new IOException("Error while reading stream", e);
                }
                finally {
                    in.close();
                }
                this.pack = new ZipVaultPackage(archive, true);
            } else {
                File tmpFile = File.createTempFile("vaultpack", ".zip");
                FileOutputStream out = FileUtils.openOutputStream((File)tmpFile);
                Binary bin = this.getData().getBinary();
                InputStream in = null;
                try {
                    in = bin.getStream();
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                    IOUtils.closeQuietly((OutputStream)out);
                    bin.dispose();
                }
                this.pack = new ZipVaultPackage(tmpFile, true);
            }
        }
        return this.pack;
    }

    public void extract(ImportOptions opts) throws RepositoryException, PackageException, IOException {
        this.extract(opts, false, false);
    }

    public void install(ImportOptions opts) throws RepositoryException, PackageException, IOException {
        this.extract(opts, true, false);
    }

    private void extract(ImportOptions options, boolean createSnapshot, boolean replaceSnapshot) throws RepositoryException, PackageException, IOException {
        this.getPackage();
        ImportOptions opts = options.copy();
        if (this.getDefinition().getBoolean("noIntermediateSaves")) {
            opts.setAutoSaveThreshold(0x7FFFFFFE);
        }
        InstallContextImpl ctx = this.pack.prepareExtract(this.node.getSession(), opts);
        JcrPackage snap = null;
        if (!opts.isDryRun() && createSnapshot) {
            ExportOptions eOpts = new ExportOptions();
            eOpts.setListener(opts.getListener());
            snap = this.snapshot(eOpts, replaceSnapshot, opts.getAccessControlHandling());
        }
        ArrayList<String> subPackages = new ArrayList<String>();
        this.pack.extract(ctx, subPackages);
        this.getDefinition();
        if (this.def != null && !opts.isDryRun()) {
            this.def.touchLastUnpacked(null, true);
        }
        Session s = this.node.getSession();
        LinkedList<JcrPackageImpl> subPacks = new LinkedList<JcrPackageImpl>();
        for (String path : subPackages) {
            if (!s.nodeExists(path)) continue;
            JcrPackageImpl p = new JcrPackageImpl(s.getNode(path));
            if (!p.isValid()) {
                try {
                    p.tryUnwrap();
                }
                catch (Exception e) {
                    log.info("Sub package {} not valid: " + e, (Object)path);
                }
            }
            if (!p.isValid()) continue;
            subPacks.add(p);
        }
        if (!opts.isNonRecursive() && !subPacks.isEmpty()) {
            block20: {
                try {
                    DependencyUtil.sortPackages(subPacks);
                }
                catch (CyclicDependencyException e) {
                    if (!opts.isStrict()) break block20;
                    throw e;
                }
            }
            LinkedList<String> subIds = new LinkedList<String>();
            SubPackageHandling sb = this.pack.getSubPackageHandling();
            for (JcrPackageImpl p : subPacks) {
                String msg;
                boolean skip = false;
                PackageId id = p.getPackage().getId();
                SubPackageHandling.Option option = sb.getOption(id);
                if (option == SubPackageHandling.Option.ADD || option == SubPackageHandling.Option.IGNORE) {
                    msg = "skipping installation of subpackage " + id + " due to option " + (Object)((Object)option);
                    skip = true;
                } else {
                    msg = option == SubPackageHandling.Option.INSTALL ? "Starting installation of subpackage " + id : "Starting extraction of subpackage " + id;
                }
                if (options.isDryRun()) {
                    msg = "Dry run: " + msg;
                }
                if (options.getListener() != null) {
                    options.getListener().onMessage(ProgressTrackerListener.Mode.TEXT, msg, "");
                } else {
                    log.info(msg);
                }
                if (!skip) {
                    if (createSnapshot && option == SubPackageHandling.Option.INSTALL) {
                        p.extract(options, true, true);
                        subIds.add(id.toString());
                    } else {
                        p.extract(options, false, true);
                    }
                }
                p.close();
            }
            if (snap != null) {
                snap.getDefinition().getNode().setProperty("subPackages", subIds.toArray(new String[subIds.size()]));
                snap.getDefinition().getNode().save();
            }
        }
    }

    public JcrPackage snapshot(ExportOptions opts, boolean replace) throws RepositoryException, PackageException, IOException {
        return this.snapshot(opts, replace, null);
    }

    private JcrPackage snapshot(ExportOptions opts, boolean replace, AccessControlHandling acHandling) throws RepositoryException, PackageException, IOException {
        PackageId id = this.getSnapshotId();
        Node packNode = this.getPackageNode(id);
        if (packNode != null) {
            if (!replace) {
                log.warn("Refusing to recreate snapshot {}, already exists.", (Object)id);
                return null;
            }
            packNode.remove();
            this.node.getSession().save();
        }
        log.info("Creating snapshot for {}.", (Object)id);
        JcrPackageManagerImpl packMgr = new JcrPackageManagerImpl(this.node.getSession());
        String path = id.getInstallationPath();
        String parentPath = Text.getRelativeParent(path, 1);
        Node folder = packMgr.mkdir(parentPath, true);
        JcrPackage snap = JcrPackageImpl.createNew(folder, id, null, true);
        JcrPackageDefinitionImpl snapDef = (JcrPackageDefinitionImpl)snap.getDefinition();
        JcrPackageDefinitionImpl myDef = (JcrPackageDefinitionImpl)this.getDefinition();
        snapDef.setId(id, false);
        snapDef.setFilter(myDef.getMetaInf().getFilter(), false);
        snapDef.set("jcr:description", "Snapshot of package " + myDef.getId().toString(), false);
        if (acHandling == null) {
            snapDef.set("acHandling", myDef.get("acHandling"), false);
        } else {
            snapDef.set("acHandling", acHandling.name(), false);
        }
        if (opts.getListener() != null) {
            opts.getListener().onMessage(ProgressTrackerListener.Mode.TEXT, "Creating snapshot for package " + myDef.getId(), "");
        }
        packMgr.assemble(snap.getNode(), snapDef, opts.getListener());
        log.info("Creating snapshot for {} completed.", (Object)id);
        return snap;
    }

    private Node getPackageNode(PackageId id) throws RepositoryException {
        if (this.node.getSession().nodeExists(id.getInstallationPath())) {
            return this.node.getSession().getNode(id.getInstallationPath());
        }
        if (this.node.getSession().nodeExists(id.getInstallationPath() + ".zip")) {
            return this.node.getSession().getNode(id.getInstallationPath() + ".zip");
        }
        return null;
    }

    public JcrPackage getSnapshot() throws RepositoryException {
        JcrPackageImpl snap;
        PackageId id = this.getSnapshotId();
        Node packNode = this.getPackageNode(id);
        if (packNode != null && (snap = new JcrPackageImpl(packNode)).isValid()) {
            return snap;
        }
        return null;
    }

    private PackageId getSnapshotId() throws RepositoryException {
        PackageId id = this.getDefinition().getId();
        String group = id.getGroup();
        group = group.length() == 0 ? ".snapshot" : group + "/.snapshot";
        return new PackageId(group, id.getName(), id.getVersion());
    }

    public void uninstall(ImportOptions opts) throws RepositoryException, PackageException, IOException {
        JcrPackage snap = this.getSnapshot();
        if (snap == null) {
            throw new PackageException("Unable to uninstall package. No snapshot present.");
        }
        if (opts.getListener() != null) {
            opts.getListener().onMessage(ProgressTrackerListener.Mode.TEXT, "Uninstalling package from snapshot " + snap.getDefinition().getId(), "");
        }
        Session s = this.getNode().getSession();
        if (!opts.isNonRecursive()) {
            Node defNode = snap.getDefNode();
            LinkedList<PackageId> subPackages = new LinkedList<PackageId>();
            if (defNode.hasProperty("subPackages")) {
                Value[] subIds;
                for (Value v : subIds = defNode.getProperty("subPackages").getValues()) {
                    subPackages.addLast(PackageId.fromString(v.getString()));
                }
            }
            if (subPackages.size() > 0) {
                JcrPackageManagerImpl packMgr = new JcrPackageManagerImpl(s);
                for (PackageId id : subPackages) {
                    JcrPackage pack = packMgr.open(id);
                    if (pack == null) continue;
                    if (pack.getSnapshot() == null) {
                        log.warn("Unable to uninstall sub package {}. Snapshot missing.", (Object)id);
                        continue;
                    }
                    pack.uninstall(opts);
                }
            }
        }
        opts.setImportMode(ImportMode.REPLACE);
        snap.extract(opts);
        snap.getNode().remove();
        s.save();
        JcrPackageDefinitionImpl def = (JcrPackageDefinitionImpl)this.getDefinition();
        def.clearLastUnpacked(true);
    }

    public long getSize() {
        try {
            this.assertValid();
            return this.getData().getLength();
        }
        catch (RepositoryException e) {
            log.error("Error during getSize()", (Throwable)e);
            return -1L;
        }
    }

    public void close() {
        this.node = null;
        if (this.pack != null) {
            this.pack.close();
            this.pack = null;
        }
    }

    private Node getContent() throws RepositoryException {
        return this.node.getNode("jcr:content");
    }

    public Property getData() throws RepositoryException {
        return this.getContent().getProperty("jcr:data");
    }

    public Node getDefNode() throws RepositoryException {
        Node content = this.getContent();
        return content.hasNode("vlt:definition") ? content.getNode("vlt:definition") : null;
    }

    private void assertValid() throws RepositoryException {
        if (!this.isValid()) {
            throw new IllegalArgumentException("not a valid package.");
        }
    }
}

