/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.impl;

import java.util.Calendar;
import java.util.Properties;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackageProperties;
import org.apache.jackrabbit.vault.packaging.SubPackageHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PackagePropertiesImpl
implements PackageProperties {
    private static final Logger log = LoggerFactory.getLogger(PackagePropertiesImpl.class);
    public static final String UNKNOWN_PATH = "/etc/packages/unknown";
    private PackageId id;

    public PackageId getId() {
        if (this.id == null) {
            String version = this.getProperty("version");
            if (version == null) {
                log.warn("Package does not specify a version. setting to ''");
                version = "";
            }
            String group = this.getProperty("group");
            String name = this.getProperty("name");
            if (group != null && name != null) {
                this.id = new PackageId(group, name, version);
            } else {
                String path = this.getProperty("path");
                if (path == null || path.length() == 0) {
                    log.warn("Package does not specify a path. setting to 'unknown'");
                    path = UNKNOWN_PATH;
                }
                this.id = new PackageId(path, version);
            }
        }
        return this.id;
    }

    public Calendar getLastModified() {
        return this.getDateProperty("lastModified");
    }

    public String getLastModifiedBy() {
        return this.getProperty("lastModifiedBy");
    }

    public Calendar getCreated() {
        return this.getDateProperty("created");
    }

    public String getCreatedBy() {
        return this.getProperty("createdBy");
    }

    public Calendar getLastWrapped() {
        return this.getDateProperty("lastWrapped");
    }

    public String getLastWrappedBy() {
        return this.getProperty("lastWrappedBy");
    }

    public String getDescription() {
        return this.getProperty("description");
    }

    public AccessControlHandling getACHandling() {
        String ac = this.getProperty("acHandling");
        if (ac == null) {
            return AccessControlHandling.IGNORE;
        }
        try {
            return AccessControlHandling.valueOf(ac.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            log.warn("invalid access control handling configured: {}", (Object)ac);
            return AccessControlHandling.IGNORE;
        }
    }

    public SubPackageHandling getSubPackageHandling() {
        return SubPackageHandling.fromString(this.getProperty("subPackageHandling"));
    }

    public boolean requiresRoot() {
        return "true".equals(this.getProperty("requiresRoot"));
    }

    public Dependency[] getDependencies() {
        String deps = this.getProperty("dependencies");
        if (deps == null) {
            return Dependency.EMPTY;
        }
        return Dependency.parse(deps);
    }

    public Calendar getDateProperty(String name) {
        try {
            String p = this.getProperty(name);
            return p == null ? null : ISO8601.parse((String)p);
        }
        catch (Exception e) {
            log.error("Error while converting date property", (Throwable)e);
            return null;
        }
    }

    public String getProperty(String name) {
        try {
            Properties props = this.getPropertiesMap();
            return props == null ? null : props.getProperty(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected abstract Properties getPropertiesMap();
}

