/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.config;

import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.vault.fs.config.AbstractConfig;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class VaultSettings
extends AbstractConfig {
    public static final String ELEM_IGNORE = "ignore";
    public static final String ATTR_IGNORE_NAME = "name";
    private Set<String> ignores = new HashSet<String>();

    public Set<String> getIgnoredNames() {
        return this.ignores;
    }

    @Override
    protected void doLoad(Element child) throws ConfigurationException {
        if (!child.getNodeName().equals(ELEM_IGNORE)) {
            throw new ConfigurationException("unexpected element: " + child.getLocalName());
        }
        this.loadIgnore(child);
    }

    public boolean isIgnored(String name) {
        return this.ignores.contains(name);
    }

    private void loadIgnore(Element ignore) {
        String name = ignore.getAttribute(ATTR_IGNORE_NAME);
        if (name != null) {
            this.ignores.add(name);
        }
    }

    @Override
    protected String getRootElemName() {
        return "vault";
    }

    @Override
    protected double getSupportedVersion() {
        return 1.0;
    }

    @Override
    protected void doWrite(ContentHandler handler) throws SAXException {
        for (String ignore : this.ignores) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", ATTR_IGNORE_NAME, "", "CDATA", ignore);
            handler.startElement("", ELEM_IGNORE, "", attrs);
            handler.endElement("", ELEM_IGNORE, "");
        }
    }

    public static VaultSettings createDefault() {
        VaultSettings s = new VaultSettings();
        s.ignores.add(".svn");
        return s;
    }
}

