/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.registry.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.jackrabbit.vault.fs.api.FilterSet;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.filter.DefaultPathFilter;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.SubPackageHandling;
import org.apache.jackrabbit.vault.packaging.registry.impl.FSPackageStatus;
import org.apache.jackrabbit.vault.util.RejectingEntityResolver;
import org.apache.jackrabbit.vault.util.xml.serialize.FormattingXmlStreamWriter;
import org.apache.jackrabbit.vault.util.xml.serialize.OutputFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FSInstallState {
    private static final String TAG_REGISTRY_METADATA = "registryMetadata";
    private static final String ATTR_PACKAGE_ID = "packageid";
    private static final String ATTR_FILE_PATH = "filepath";
    private static final String ATTR_PACKAGE_STATUS = "packagestatus";
    private static final String ATTR_EXTERNAL = "external";
    private static final String ATTR_SIZE = "size";
    private static final String TAG_DEPENDENCY = "dependency";
    private static final String TAG_SUBPACKAGE = "subpackage";
    private static final String ATTR_INSTALLATION_TIME = "installtime";
    private static final String ATTR_SUBPACKAGE_HANDLING_OPTION = "sphoption";
    private static final String TAG_FILTER = "filter";
    private static final String TAG_WORKSPACEFILTER = "workspacefilter";
    private static final String ATTR_ROOT = "root";
    private static final String TAG_RULE = "rule";
    private static final String ATTR_INCLUDE = "include";
    private static final String ATTR_EXCLUDE = "exclude";
    private static final String TAG_PACKAGEPROPERTIES = "packageproperties";
    @NotNull
    private final PackageId packageId;
    @NotNull
    private final FSPackageStatus status;
    @NotNull
    private final Path filePath;
    private boolean external;
    private Set<Dependency> dependencies = Collections.emptySet();
    private Map<PackageId, SubPackageHandling.Option> subPackages = Collections.emptyMap();
    private Long installTime;
    private long size = 0L;
    private WorkspaceFilter filter;
    private Properties properties = new Properties();

    public FSInstallState(@NotNull PackageId pid, @NotNull FSPackageStatus status, @NotNull Path filePath) {
        this.packageId = pid;
        this.status = status;
        this.filePath = filePath;
    }

    public FSInstallState withExternal(boolean external) {
        this.external = external;
        return this;
    }

    public FSInstallState withDependencies(Set<Dependency> dependencies) {
        this.dependencies = dependencies == null ? Collections.emptySet() : Collections.unmodifiableSet(dependencies);
        return this;
    }

    public FSInstallState withSubPackages(Map<PackageId, SubPackageHandling.Option> subPackages) {
        this.subPackages = subPackages == null ? Collections.emptyMap() : Collections.unmodifiableMap(subPackages);
        return this;
    }

    public FSInstallState withInstallTime(Long installTime) {
        this.installTime = installTime;
        return this;
    }

    public FSInstallState withSize(long size) {
        this.size = size;
        return this;
    }

    public FSInstallState withFilter(WorkspaceFilter filter) {
        this.filter = filter;
        return this;
    }

    public FSInstallState withProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    @Nullable
    public static FSInstallState fromFile(Path metaFile) throws IOException {
        if (!Files.exists(metaFile, new LinkOption[0])) {
            return null;
        }
        try (InputStream in = Files.newInputStream(metaFile, new OpenOption[0]);){
            FSInstallState fSInstallState = FSInstallState.fromStream(in, metaFile.toString());
            return fSInstallState;
        }
    }

    @Nullable
    public static FSInstallState fromStream(InputStream in, String systemId) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new RejectingEntityResolver());
            Document document = builder.parse(in, systemId);
            Element doc = document.getDocumentElement();
            if (!TAG_REGISTRY_METADATA.equals(doc.getNodeName())) {
                return null;
            }
            String packageId = doc.getAttribute(ATTR_PACKAGE_ID);
            Path filePath = Paths.get(doc.getAttribute(ATTR_FILE_PATH), new String[0]);
            Long installTime = null;
            if (doc.hasAttribute(ATTR_INSTALLATION_TIME)) {
                installTime = Long.valueOf(doc.getAttribute(ATTR_INSTALLATION_TIME));
            }
            boolean external = Boolean.parseBoolean(doc.getAttribute(ATTR_EXTERNAL));
            long size = 0L;
            if (doc.hasAttribute(ATTR_SIZE)) {
                size = Long.valueOf(doc.getAttribute(ATTR_SIZE));
            }
            FSPackageStatus status = FSPackageStatus.valueOf(doc.getAttribute(ATTR_PACKAGE_STATUS).toUpperCase());
            NodeList nl = doc.getChildNodes();
            HashSet<Dependency> dependencies = new HashSet<Dependency>();
            HashMap<PackageId, SubPackageHandling.Option> subPackages = new HashMap<PackageId, SubPackageHandling.Option>();
            WorkspaceFilter filter = null;
            Properties properties = new Properties();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node child = nl.item(i);
                if (child.getNodeType() != 1) continue;
                String childName = child.getNodeName();
                if (TAG_DEPENDENCY.equals(childName)) {
                    dependencies.add(FSInstallState.readDependency((Element)child));
                    continue;
                }
                if (TAG_SUBPACKAGE.equals(childName)) {
                    subPackages.put(FSInstallState.readPackageId((Element)child), FSInstallState.readSubPackgeHandlingOption((Element)child));
                    continue;
                }
                if (TAG_WORKSPACEFILTER.equals(childName)) {
                    filter = FSInstallState.readWorkspaceFilter((Element)child);
                    continue;
                }
                if (TAG_PACKAGEPROPERTIES.equals(childName)) {
                    properties = FSInstallState.readProperties((Element)child);
                    continue;
                }
                throw new IOException("<dependency> or <subpackage> or <workspacefilter> expected.");
            }
            return new FSInstallState(PackageId.fromString(packageId), status, filePath).withExternal(external).withSize(size).withFilter(filter).withDependencies(dependencies).withSubPackages(subPackages).withProperties(properties).withInstallTime(installTime);
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Unable to create configuration XML parser", e);
        }
        catch (SAXException e) {
            throw new IOException("Configuration file syntax error.", e);
        }
        catch (ConfigurationException e) {
            throw new IOException("Configuration file syntax error.", e);
        }
    }

    private static Properties readProperties(Element child) {
        Properties properties = new Properties();
        NamedNodeMap attributes = child.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            properties.put(attr.getNodeName(), attr.getNodeValue());
        }
        return properties;
    }

    private static Dependency readDependency(Element child) {
        return Dependency.fromString(child.getAttribute(ATTR_PACKAGE_ID));
    }

    private static SubPackageHandling.Option readSubPackgeHandlingOption(Element child) {
        return SubPackageHandling.Option.valueOf(child.getAttribute(ATTR_SUBPACKAGE_HANDLING_OPTION));
    }

    private static PackageId readPackageId(Element child) {
        return PackageId.fromString(child.getAttribute(ATTR_PACKAGE_ID));
    }

    private static WorkspaceFilter readWorkspaceFilter(Element child) throws ConfigurationException {
        DefaultWorkspaceFilter wsfilter = new DefaultWorkspaceFilter();
        NodeList nl = child.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node filter = nl.item(i);
            if (filter.getNodeType() != 1) continue;
            PathFilterSet pfs = new PathFilterSet(((Element)filter).getAttribute(ATTR_ROOT));
            NodeList nlf = filter.getChildNodes();
            for (int j = 0; j < nlf.getLength(); ++j) {
                DefaultPathFilter pf;
                Node rule = nlf.item(j);
                if (rule.getNodeType() != 1) continue;
                if (((Element)rule).hasAttribute(ATTR_INCLUDE)) {
                    pf = new DefaultPathFilter(((Element)rule).getAttribute(ATTR_INCLUDE));
                    pfs.addInclude(pf);
                    continue;
                }
                if (!((Element)rule).hasAttribute(ATTR_EXCLUDE)) continue;
                pf = new DefaultPathFilter(((Element)rule).getAttribute(ATTR_EXCLUDE));
                pfs.addExclude(pf);
            }
            wsfilter.add(pfs);
        }
        return wsfilter;
    }

    public void save(Path file) throws IOException {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        try (OutputStream out = Files.newOutputStream(file, StandardOpenOption.CREATE);){
            this.save(out);
        }
    }

    public void save(OutputStream out) throws IOException {
        try (FormattingXmlStreamWriter writer = FormattingXmlStreamWriter.create(out, new OutputFormat(4, false));){
            writer.writeStartDocument();
            writer.writeStartElement(TAG_REGISTRY_METADATA);
            writer.writeAttribute(ATTR_PACKAGE_ID, this.packageId.toString());
            writer.writeAttribute(ATTR_SIZE, Long.toString(this.size));
            if (this.installTime != null) {
                writer.writeAttribute(ATTR_INSTALLATION_TIME, Long.toString(this.installTime));
            }
            writer.writeAttribute(ATTR_FILE_PATH, this.filePath.toString());
            writer.writeAttribute(ATTR_EXTERNAL, Boolean.toString(this.external));
            writer.writeAttribute(ATTR_PACKAGE_STATUS, this.status.name().toLowerCase());
            if (this.filter != null && !this.filter.getFilterSets().isEmpty()) {
                writer.writeStartElement(TAG_WORKSPACEFILTER);
                for (PathFilterSet pathFilterSet : this.filter.getFilterSets()) {
                    writer.writeStartElement(TAG_FILTER);
                    writer.writeAttribute(ATTR_ROOT, pathFilterSet.getRoot());
                    for (FilterSet.Entry pf : pathFilterSet.getEntries()) {
                        writer.writeStartElement(TAG_RULE);
                        DefaultPathFilter dpf = (DefaultPathFilter)pf.getFilter();
                        if (pf.isInclude()) {
                            writer.writeAttribute(ATTR_INCLUDE, dpf.getPattern());
                        } else {
                            writer.writeAttribute(ATTR_EXCLUDE, dpf.getPattern());
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (this.dependencies != null) {
                for (Dependency dependency : this.dependencies) {
                    writer.writeStartElement(TAG_DEPENDENCY);
                    writer.writeAttribute(ATTR_PACKAGE_ID, dependency.toString());
                    writer.writeEndElement();
                }
            }
            if (this.subPackages != null) {
                for (Map.Entry entry : this.subPackages.entrySet()) {
                    writer.writeStartElement(TAG_SUBPACKAGE);
                    writer.writeAttribute(ATTR_PACKAGE_ID, ((PackageId)entry.getKey()).toString());
                    writer.writeAttribute(ATTR_SUBPACKAGE_HANDLING_OPTION, ((SubPackageHandling.Option)((Object)entry.getValue())).toString());
                    writer.writeEndElement();
                }
            }
            if (this.properties.size() > 0) {
                writer.writeStartElement(TAG_PACKAGEPROPERTIES);
                for (String string : this.properties.stringPropertyNames()) {
                    writer.writeAttribute(string, this.properties.getProperty(string));
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException(e);
        }
    }

    public Long getInstallationTime() {
        return this.installTime;
    }

    public Map<PackageId, SubPackageHandling.Option> getSubPackages() {
        return this.subPackages;
    }

    public PackageId getPackageId() {
        return this.packageId;
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public boolean isExternal() {
        return this.external;
    }

    public FSPackageStatus getStatus() {
        return this.status;
    }

    public Set<Dependency> getDependencies() {
        return this.dependencies;
    }

    public long getSize() {
        return this.size;
    }

    public WorkspaceFilter getFilter() {
        return this.filter;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dependencies == null ? 0 : this.dependencies.hashCode());
        result = 31 * result + (this.external ? 1231 : 1237);
        result = 31 * result + (this.filePath == null ? 0 : this.filePath.hashCode());
        result = 31 * result + (this.filter == null ? 0 : this.filter.hashCode());
        result = 31 * result + (this.installTime == null ? 0 : this.installTime.hashCode());
        result = 31 * result + (this.packageId == null ? 0 : this.packageId.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.subPackages == null ? 0 : this.subPackages.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FSInstallState other = (FSInstallState)obj;
        if (this.dependencies == null ? other.dependencies != null : !this.dependencies.equals(other.dependencies)) {
            return false;
        }
        if (this.external != other.external) {
            return false;
        }
        if (this.filePath == null ? other.filePath != null : !this.filePath.equals(other.filePath)) {
            return false;
        }
        if (this.filter == null ? other.filter != null : !this.filter.equals(other.filter)) {
            return false;
        }
        if (this.installTime == null ? other.installTime != null : !this.installTime.equals(other.installTime)) {
            return false;
        }
        if (this.packageId == null ? other.packageId != null : !this.packageId.equals(other.packageId)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        return !(this.subPackages == null ? other.subPackages != null : !this.subPackages.equals(other.subPackages));
    }

    public String toString() {
        return "FSInstallState [" + (this.packageId != null ? "packageId=" + this.packageId + ", " : "") + (this.status != null ? "status=" + (Object)((Object)this.status) + ", " : "") + (this.filePath != null ? "filePath=" + this.filePath + ", " : "") + "external=" + this.external + ", " + (this.dependencies != null ? "dependencies=" + this.dependencies + ", " : "") + (this.subPackages != null ? "subPackages=" + this.subPackages + ", " : "") + (this.installTime != null ? "installTime=" + this.installTime + ", " : "") + "size=" + this.size + ", " + (this.filter != null ? "filter=" + this.filter + ", " : "") + (this.properties != null ? "properties=" + this.properties : "") + "]";
    }
}

