/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.es;

import com.github.fge.lambdas.Throwing;
import com.github.fge.lambdas.consumers.ConsumerChainer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.util.Optional;
import org.apache.james.backends.es.ClientProvider;
import org.apache.james.util.Host;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;

public class ClientProviderImpl
implements ClientProvider {
    private static final String CLUSTER_NAME_SETTING = "cluster.name";
    private final ImmutableList<Host> hosts;
    private final Optional<String> clusterName;

    public static ClientProviderImpl forHost(String address, Integer port, Optional<String> clusterName) {
        return new ClientProviderImpl((ImmutableList<Host>)ImmutableList.of((Object)Host.from((String)address, (int)port)), clusterName);
    }

    public static ClientProviderImpl fromHostsString(String hostsString, Optional<String> clusterName) {
        Preconditions.checkNotNull((Object)hostsString, (Object)"HostString should not be null");
        return new ClientProviderImpl((ImmutableList<Host>)Host.parseHosts((String)hostsString), clusterName);
    }

    public static ClientProviderImpl fromHosts(ImmutableList<Host> hosts, Optional<String> clusterName) {
        Preconditions.checkNotNull(hosts, (Object)"Hosts should not be null");
        return new ClientProviderImpl(hosts, clusterName);
    }

    private ClientProviderImpl(ImmutableList<Host> hosts, Optional<String> clusterName) {
        Preconditions.checkArgument((!hosts.isEmpty() ? 1 : 0) != 0, (Object)"You should provide at least one host");
        this.hosts = hosts;
        this.clusterName = clusterName;
    }

    @Override
    public Client get() {
        TransportClient transportClient = TransportClient.builder().settings(this.settings()).build();
        ConsumerChainer consumer = Throwing.consumer(host -> transportClient.addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(host.getHostName()), host.getPort())));
        this.hosts.forEach(consumer.sneakyThrow());
        return transportClient;
    }

    @VisibleForTesting
    Settings settings() {
        if (this.clusterName.isPresent()) {
            return Settings.builder().put(CLUSTER_NAME_SETTING, this.clusterName.get()).build();
        }
        return Settings.EMPTY;
    }
}

