/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.es;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.james.backends.es.TypeName;
import org.apache.james.backends.es.WriteAliasName;
import org.apache.james.backends.es.search.ScrollIterable;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;

public class DeleteByQueryPerformer {
    public static final TimeValue TIMEOUT = new TimeValue(60000L);
    private final Client client;
    private final ExecutorService executor;
    private final int batchSize;
    private final WriteAliasName aliasName;
    private final TypeName typeName;

    @VisibleForTesting
    public DeleteByQueryPerformer(Client client, ExecutorService executor, int batchSize, WriteAliasName aliasName, TypeName typeName) {
        this.client = client;
        this.executor = executor;
        this.batchSize = batchSize;
        this.aliasName = aliasName;
        this.typeName = typeName;
    }

    public Future<Void> perform(QueryBuilder queryBuilder) {
        return this.executor.submit(() -> this.doDeleteByQuery(queryBuilder));
    }

    protected Void doDeleteByQuery(QueryBuilder queryBuilder) {
        new ScrollIterable(this.client, this.client.prepareSearch(new String[]{this.aliasName.getValue()}).setTypes(new String[]{this.typeName.getValue()}).setScroll(TIMEOUT).setNoFields().setQuery(queryBuilder).setSize(this.batchSize)).stream().map(searchResponse -> this.deleteRetrievedIds(this.client, (SearchResponse)searchResponse)).forEach(ActionFuture::actionGet);
        return null;
    }

    private ListenableActionFuture<BulkResponse> deleteRetrievedIds(Client client, SearchResponse searchResponse) {
        BulkRequestBuilder bulkRequestBuilder = client.prepareBulk();
        for (SearchHit hit : searchResponse.getHits()) {
            bulkRequestBuilder.add(((DeleteRequestBuilder)client.prepareDelete().setIndex(this.aliasName.getValue())).setType(this.typeName.getValue()).setId(hit.getId()));
        }
        return bulkRequestBuilder.execute();
    }
}

