/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.es;

import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.util.Host;

public class ElasticSearchConfiguration {
    public static final String ELASTICSEARCH_HOSTS = "elasticsearch.hosts";
    public static final String ELASTICSEARCH_CLUSTER_NAME = "elasticsearch.clusterName";
    public static final String ELASTICSEARCH_MASTER_HOST = "elasticsearch.masterHost";
    public static final String ELASTICSEARCH_PORT = "elasticsearch.port";
    public static final String ELASTICSEARCH_NB_REPLICA = "elasticsearch.nb.replica";
    public static final String ELASTICSEARCH_NB_SHARDS = "elasticsearch.nb.shards";
    public static final String ELASTICSEARCH_RETRY_CONNECTION_MIN_DELAY = "elasticsearch.retryConnection.minDelay";
    public static final String ELASTICSEARCH_RETRY_CONNECTION_MAX_RETRIES = "elasticsearch.retryConnection.maxRetries";
    public static final int DEFAULT_CONNECTION_MAX_RETRIES = 7;
    public static final int DEFAULT_CONNECTION_MIN_DELAY = 3000;
    public static final int DEFAULT_NB_SHARDS = 5;
    public static final int DEFAULT_NB_REPLICA = 1;
    public static final int DEFAULT_PORT = 9300;
    private static final String LOCALHOST = "127.0.0.1";
    public static final Optional<Integer> DEFAULT_PORT_AS_OPTIONAL = Optional.of(9300);
    public static final ElasticSearchConfiguration DEFAULT_CONFIGURATION = ElasticSearchConfiguration.builder().addHost(Host.from((String)"127.0.0.1", (int)9300)).build();
    private final ImmutableList<Host> hosts;
    private final Optional<String> clusterName;
    private final int nbShards;
    private final int nbReplica;
    private final int minDelay;
    private final int maxRetries;

    public static Builder builder() {
        return new Builder();
    }

    public static ElasticSearchConfiguration fromProperties(Configuration configuration) throws ConfigurationException {
        return ElasticSearchConfiguration.builder().addHosts((Collection<Host>)ElasticSearchConfiguration.getHosts(configuration)).clusterName(configuration.getString(ELASTICSEARCH_CLUSTER_NAME)).nbShards(configuration.getInteger(ELASTICSEARCH_NB_SHARDS, Integer.valueOf(5))).nbReplica(configuration.getInteger(ELASTICSEARCH_NB_REPLICA, Integer.valueOf(1))).minDelay(Optional.ofNullable(configuration.getInteger(ELASTICSEARCH_RETRY_CONNECTION_MIN_DELAY, null))).maxRetries(Optional.ofNullable(configuration.getInteger(ELASTICSEARCH_RETRY_CONNECTION_MAX_RETRIES, null))).build();
    }

    private static ImmutableList<Host> getHosts(Configuration propertiesReader) throws ConfigurationException {
        AbstractConfiguration.setDefaultListDelimiter((char)',');
        Optional<String> masterHost = Optional.ofNullable(propertiesReader.getString(ELASTICSEARCH_MASTER_HOST, null));
        Optional<Integer> masterPort = Optional.ofNullable(propertiesReader.getInteger(ELASTICSEARCH_PORT, null));
        List<String> multiHosts = Arrays.asList(propertiesReader.getStringArray(ELASTICSEARCH_HOSTS));
        ElasticSearchConfiguration.validateHostsConfigurationOptions(masterHost, masterPort, multiHosts);
        if (masterHost.isPresent()) {
            return ImmutableList.of((Object)Host.from((String)masterHost.get(), (int)masterPort.get()));
        }
        return (ImmutableList)multiHosts.stream().map(ipAndPort -> Host.parse((String)ipAndPort, DEFAULT_PORT_AS_OPTIONAL)).collect(Guavate.toImmutableList());
    }

    @VisibleForTesting
    static void validateHostsConfigurationOptions(Optional<String> masterHost, Optional<Integer> masterPort, List<String> multiHosts) throws ConfigurationException {
        if (masterHost.isPresent() != masterPort.isPresent()) {
            throw new ConfigurationException("elasticsearch.masterHost and elasticsearch.port should be specified together");
        }
        if (!multiHosts.isEmpty() && masterHost.isPresent()) {
            throw new ConfigurationException("You should choose between mono host set up and elasticsearch.hosts");
        }
        if (multiHosts.isEmpty() && !masterHost.isPresent()) {
            throw new ConfigurationException("You should specify either (elasticsearch.masterHost and elasticsearch.port) or elasticsearch.hosts");
        }
    }

    private ElasticSearchConfiguration(ImmutableList<Host> hosts, Optional<String> clusterName, int nbShards, int nbReplica, int minDelay, int maxRetries) {
        this.hosts = hosts;
        this.clusterName = clusterName;
        this.nbShards = nbShards;
        this.nbReplica = nbReplica;
        this.minDelay = minDelay;
        this.maxRetries = maxRetries;
    }

    public ImmutableList<Host> getHosts() {
        return this.hosts;
    }

    public Optional<String> getClusterName() {
        return this.clusterName;
    }

    public int getNbShards() {
        return this.nbShards;
    }

    public int getNbReplica() {
        return this.nbReplica;
    }

    public int getMinDelay() {
        return this.minDelay;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public final boolean equals(Object o) {
        if (o instanceof ElasticSearchConfiguration) {
            ElasticSearchConfiguration that = (ElasticSearchConfiguration)o;
            return Objects.equals(this.nbShards, that.nbShards) && Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.nbReplica, that.nbReplica) && Objects.equals(this.minDelay, that.minDelay) && Objects.equals(this.maxRetries, that.maxRetries) && Objects.equals(this.hosts, that.hosts);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.hosts, this.clusterName, this.nbShards, this.nbReplica, this.minDelay, this.maxRetries);
    }

    public static class Builder {
        private final ImmutableList.Builder<Host> hosts = ImmutableList.builder();
        private Optional<String> clusterName = Optional.empty();
        private Optional<Integer> nbShards = Optional.empty();
        private Optional<Integer> nbReplica = Optional.empty();
        private Optional<Integer> minDelay = Optional.empty();
        private Optional<Integer> maxRetries = Optional.empty();

        public Builder addHost(Host host) {
            this.hosts.add((Object)host);
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.clusterName = Optional.ofNullable(clusterName);
            return this;
        }

        public Builder addHosts(Collection<Host> hosts) {
            this.hosts.addAll(hosts);
            return this;
        }

        public Builder nbShards(int nbShards) {
            Preconditions.checkArgument((nbShards > 0 ? 1 : 0) != 0, (Object)"You need the number of shards to be strictly positive");
            this.nbShards = Optional.of(nbShards);
            return this;
        }

        public Builder nbReplica(int nbReplica) {
            Preconditions.checkArgument((nbReplica >= 0 ? 1 : 0) != 0, (Object)"You need the number of replica to be positive");
            this.nbReplica = Optional.of(nbReplica);
            return this;
        }

        public Builder minDelay(Optional<Integer> minDelay) {
            this.minDelay = minDelay;
            return this;
        }

        public Builder maxRetries(Optional<Integer> maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public ElasticSearchConfiguration build() {
            ImmutableList hosts = this.hosts.build();
            Preconditions.checkState((!hosts.isEmpty() ? 1 : 0) != 0, (Object)"You need to specify ElasticSearch host");
            return new ElasticSearchConfiguration(hosts, this.clusterName, this.nbShards.orElse(5), this.nbReplica.orElse(1), this.minDelay.orElse(3000), this.maxRetries.orElse(7));
        }
    }
}

