/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.es;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.backends.es.AliasName;
import org.apache.james.backends.es.DeleteByQueryPerformer;
import org.apache.james.backends.es.TypeName;
import org.apache.james.backends.es.UpdatedRepresentation;
import org.apache.james.backends.es.WriteAliasName;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.index.query.QueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchIndexer {
    private static final int DEBUG_MAX_LENGTH_CONTENT = 1000;
    private static final int DEFAULT_BATCH_SIZE = 100;
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchIndexer.class);
    private final Client client;
    private final DeleteByQueryPerformer deleteByQueryPerformer;
    private final AliasName aliasName;
    private final TypeName typeName;

    public ElasticSearchIndexer(Client client, ExecutorService executor, WriteAliasName aliasName, TypeName typeName) {
        this(client, executor, aliasName, typeName, 100);
    }

    @VisibleForTesting
    public ElasticSearchIndexer(Client client, ExecutorService executor, WriteAliasName aliasName, TypeName typeName, int batchSize) {
        this.client = client;
        this.deleteByQueryPerformer = new DeleteByQueryPerformer(client, executor, batchSize, aliasName, typeName);
        this.aliasName = aliasName;
        this.typeName = typeName;
    }

    public IndexResponse index(String id, String content) {
        this.checkArgument(content);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Indexing {}: {}", (Object)id, (Object)StringUtils.left((String)content, (int)1000));
        }
        return (IndexResponse)this.client.prepareIndex(this.aliasName.getValue(), this.typeName.getValue(), id).setSource(content).get();
    }

    public Optional<BulkResponse> update(List<UpdatedRepresentation> updatedDocumentParts) {
        try {
            Preconditions.checkNotNull(updatedDocumentParts);
            BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
            updatedDocumentParts.forEach(updatedDocumentPart -> bulkRequestBuilder.add(this.client.prepareUpdate(this.aliasName.getValue(), this.typeName.getValue(), updatedDocumentPart.getId()).setDoc(updatedDocumentPart.getUpdatedDocumentPart())));
            return Optional.of(bulkRequestBuilder.get());
        }
        catch (ValidationException e) {
            LOGGER.warn("Error while updating index", (Throwable)e);
            return Optional.empty();
        }
    }

    public Optional<BulkResponse> delete(List<String> ids) {
        try {
            BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
            ids.forEach(id -> bulkRequestBuilder.add(this.client.prepareDelete(this.aliasName.getValue(), this.typeName.getValue(), id)));
            return Optional.of(bulkRequestBuilder.get());
        }
        catch (ValidationException e) {
            LOGGER.warn("Error while deleting index", (Throwable)e);
            return Optional.empty();
        }
    }

    public Future<Void> deleteAllMatchingQuery(QueryBuilder queryBuilder) {
        return this.deleteByQueryPerformer.perform(queryBuilder);
    }

    private void checkArgument(String content) {
        Preconditions.checkArgument((content != null ? 1 : 0) != 0, (Object)"content should be provided");
    }
}

