/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.es;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;
import org.apache.james.backends.es.AliasName;
import org.apache.james.backends.es.ElasticSearchConfiguration;
import org.apache.james.backends.es.IndexName;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.exists.AliasesExistResponse;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexCreationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexCreationFactory.class);
    public static final String CASE_INSENSITIVE = "case_insensitive";
    public static final String KEEP_MAIL_AND_URL = "keep_mail_and_url";
    public static final String SNOWBALL_KEEP_MAIL_AND_URL = "snowball_keep_mail_and_token";
    public static final String ENGLISH_SNOWBALL = "english_snowball";
    private IndexName indexName = null;
    private ArrayList<AliasName> aliases = new ArrayList();
    private int nbShards;
    private int nbReplica;

    @Inject
    public IndexCreationFactory(ElasticSearchConfiguration configuration) {
        this.nbShards = configuration.getNbShards();
        this.nbReplica = configuration.getNbReplica();
    }

    public IndexCreationFactory useIndex(IndexName indexName) {
        Preconditions.checkNotNull((Object)indexName);
        this.indexName = indexName;
        return this;
    }

    public IndexCreationFactory addAlias(AliasName aliasName) {
        Preconditions.checkNotNull((Object)aliasName);
        this.aliases.add(aliasName);
        return this;
    }

    public Client createIndexAndAliases(Client client) {
        Preconditions.checkNotNull((Object)this.indexName);
        try {
            this.createIndexIfNeeded(client, this.indexName, this.generateSetting(this.nbShards, this.nbReplica));
            this.aliases.forEach(alias -> this.createAliasIfNeeded(client, this.indexName, (AliasName)alias));
        }
        catch (IOException e) {
            LOGGER.error("Error while creating index : ", (Throwable)e);
        }
        return client;
    }

    private void createAliasIfNeeded(Client client, IndexName indexName, AliasName aliasName) {
        if (!this.aliasExist(client, aliasName)) {
            client.admin().indices().aliases(new IndicesAliasesRequest().addAlias(aliasName.getValue(), new String[]{indexName.getValue()})).actionGet();
        }
    }

    private boolean aliasExist(Client client, AliasName aliasName) {
        return ((AliasesExistResponse)client.admin().indices().aliasesExist(new GetAliasesRequest().aliases(new String[]{aliasName.getValue()})).actionGet()).exists();
    }

    private void createIndexIfNeeded(Client client, IndexName indexName, XContentBuilder settings) {
        try {
            client.admin().indices().prepareCreate(indexName.getValue()).setSettings(settings).execute().actionGet();
        }
        catch (IndexAlreadyExistsException exception) {
            LOGGER.info("Index [{}] already exist", (Object)indexName);
        }
    }

    private XContentBuilder generateSetting(int nbShards, int nbReplica) throws IOException {
        return XContentFactory.jsonBuilder().startObject().field("number_of_shards", nbShards).field("number_of_replicas", nbReplica).startObject("analysis").startObject("analyzer").startObject(CASE_INSENSITIVE).field("tokenizer", "keyword").startArray("filter").value("lowercase").endArray().endObject().endObject().startObject("analyzer").startObject(KEEP_MAIL_AND_URL).field("tokenizer", "uax_url_email").startArray("filter").value("lowercase").value("stop").endArray().endObject().endObject().startObject("filter").startObject(ENGLISH_SNOWBALL).field("type", "snowball").field("language", "English").endObject().endObject().startObject("analyzer").startObject(SNOWBALL_KEEP_MAIL_AND_URL).field("tokenizer", "uax_url_email").startArray("filter").value("lowercase").value("stop").value(ENGLISH_SNOWBALL).endArray().endObject().endObject().endObject().endObject();
    }
}

