/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.es;

import java.util.Iterator;
import org.apache.james.backends.es.IndexName;
import org.apache.james.backends.es.TypeName;
import org.apache.james.util.streams.Iterators;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class NodeMappingFactory {
    public static final String BOOLEAN = "boolean";
    public static final String TYPE = "type";
    public static final String LONG = "long";
    public static final String DOUBLE = "double";
    public static final String INDEX = "index";
    public static final String NOT_ANALYZED = "not_analyzed";
    public static final String STRING = "string";
    public static final String PROPERTIES = "properties";
    public static final String DATE = "date";
    public static final String FORMAT = "format";
    public static final String NESTED = "nested";
    public static final String FIELDS = "fields";
    public static final String RAW = "raw";
    public static final String SPLIT_EMAIL = "splitEmail";
    public static final String ANALYZER = "analyzer";
    public static final String SEARCH_ANALYZER = "search_analyzer";
    public static final String SNOWBALL = "snowball";
    public static final String IGNORE_ABOVE = "ignore_above";

    public static Client applyMapping(Client client, IndexName indexName, TypeName typeName, XContentBuilder mappingsSources) {
        if (!NodeMappingFactory.mappingAlreadyExist(client, indexName, typeName)) {
            NodeMappingFactory.createMapping(client, indexName, typeName, mappingsSources);
        }
        return client;
    }

    public static boolean mappingAlreadyExist(Client client, IndexName indexName, TypeName typeName) {
        return Iterators.toStream((Iterator)((GetMappingsResponse)client.admin().indices().prepareGetMappings(new String[]{indexName.getValue()}).execute().actionGet()).getMappings().valuesIt()).anyMatch(mapping -> mapping.keys().contains((Object)typeName.getValue()));
    }

    public static void createMapping(Client client, IndexName indexName, TypeName typeName, XContentBuilder mappingsSources) {
        client.admin().indices().preparePutMapping(new String[]{indexName.getValue()}).setType(typeName.getValue()).setSource(mappingsSources).execute().actionGet();
    }
}

