/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.es;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.elasticsearch.common.Strings;

public class UpdatedRepresentation {
    private final String id;
    private final String updatedDocumentPart;

    public UpdatedRepresentation(String id, String updatedDocumentPart) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)("Updated id must be specified " + id));
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)updatedDocumentPart) ? 1 : 0) != 0, (Object)"Updated document must be specified");
        this.id = id;
        this.updatedDocumentPart = updatedDocumentPart;
    }

    public String getId() {
        return this.id;
    }

    public String getUpdatedDocumentPart() {
        return this.updatedDocumentPart;
    }

    public final boolean equals(Object o) {
        if (o instanceof UpdatedRepresentation) {
            UpdatedRepresentation other = (UpdatedRepresentation)o;
            return Objects.equals(this.id, other.id) && Objects.equals(this.updatedDocumentPart, other.updatedDocumentPart);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.id, this.updatedDocumentPart);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("updatedDocumentPart", (Object)this.updatedDocumentPart).toString();
    }
}

