/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.FileUtils;
import org.apache.james.mailbox.AbstractMailboxManagerTest;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.acl.GroupMembershipResolver;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.acl.SimpleGroupMembershipResolver;
import org.apache.james.mailbox.acl.UnionMailboxACLResolver;
import org.apache.james.mailbox.exception.BadCredentialsException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.maildir.MaildirMailboxSessionMapperFactory;
import org.apache.james.mailbox.maildir.MaildirStore;
import org.apache.james.mailbox.maildir.OsDetector;
import org.apache.james.mailbox.store.JVMMailboxPathLocker;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MaildirMailboxManagerTest
extends AbstractMailboxManagerTest {
    private static final String MAILDIR_HOME = "target/Maildir";

    @Before
    public void setup() throws Exception {
        if (OsDetector.isWindows()) {
            System.out.println("Maildir tests work only on non-windows systems. So skip the test");
        } else {
            this.deleteMaildirTestDirectory();
        }
    }

    @After
    public void tearDown() throws IOException {
        if (OsDetector.isWindows()) {
            System.out.println("Maildir tests work only on non-windows systems. So skip the test");
        } else {
            this.deleteMaildirTestDirectory();
        }
    }

    @Test
    public void testList() throws MailboxException, UnsupportedEncodingException {
        if (OsDetector.isWindows()) {
            System.out.println("Maildir tests work only on non-windows systems. So skip the test");
        } else {
            this.doTestListWithMaildirStoreConfiguration("/%domain/%user");
            try {
                this.doTestListWithMaildirStoreConfiguration("/%user");
                Assert.fail();
            }
            catch (MailboxExistsException mailboxExistsException) {
                // empty catch block
            }
            this.doTestListWithMaildirStoreConfiguration("/%fulluser");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicOperations() throws BadCredentialsException, MailboxException, UnsupportedEncodingException {
        if (OsDetector.isWindows()) {
            System.out.println("Maildir tests work only on non-windows systems. So skip the test");
        } else {
            MaildirStore store = new MaildirStore("target/Maildir/%domain/%user", (MailboxPathLocker)new JVMMailboxPathLocker());
            MaildirMailboxSessionMapperFactory mf = new MaildirMailboxSessionMapperFactory(store);
            UnionMailboxACLResolver aclResolver = new UnionMailboxACLResolver();
            SimpleGroupMembershipResolver groupMembershipResolver = new SimpleGroupMembershipResolver();
            StoreMailboxManager manager = new StoreMailboxManager((MailboxSessionMapperFactory)mf, null, (MailboxPathLocker)new JVMMailboxPathLocker(), (MailboxACLResolver)aclResolver, (GroupMembershipResolver)groupMembershipResolver);
            manager.init();
            this.setMailboxManager((MailboxManager)manager);
            try {
                super.testBasicOperations();
            }
            finally {
                try {
                    this.deleteMaildirTestDirectory();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateSubFolderDirectly() throws BadCredentialsException, MailboxException {
        if (OsDetector.isWindows()) {
            System.out.println("Maildir tests work only on non-windows systems. So skip the test");
        } else {
            MaildirStore store = new MaildirStore("target/Maildir/%domain/%user", (MailboxPathLocker)new JVMMailboxPathLocker());
            MaildirMailboxSessionMapperFactory mf = new MaildirMailboxSessionMapperFactory(store);
            UnionMailboxACLResolver aclResolver = new UnionMailboxACLResolver();
            SimpleGroupMembershipResolver groupMembershipResolver = new SimpleGroupMembershipResolver();
            StoreMailboxManager manager = new StoreMailboxManager((MailboxSessionMapperFactory)mf, null, (MailboxPathLocker)new JVMMailboxPathLocker(), (MailboxACLResolver)aclResolver, (GroupMembershipResolver)groupMembershipResolver);
            manager.init();
            this.setMailboxManager((MailboxManager)manager);
            try {
                super.testCreateSubFolderDirectly();
            }
            finally {
                try {
                    this.deleteMaildirTestDirectory();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestListWithMaildirStoreConfiguration(String maildirStoreConfiguration) throws MailboxException, UnsupportedEncodingException {
        MaildirStore store = new MaildirStore(MAILDIR_HOME + maildirStoreConfiguration, (MailboxPathLocker)new JVMMailboxPathLocker());
        MaildirMailboxSessionMapperFactory mf = new MaildirMailboxSessionMapperFactory(store);
        UnionMailboxACLResolver aclResolver = new UnionMailboxACLResolver();
        SimpleGroupMembershipResolver groupMembershipResolver = new SimpleGroupMembershipResolver();
        StoreMailboxManager manager = new StoreMailboxManager((MailboxSessionMapperFactory)mf, null, (MailboxPathLocker)new JVMMailboxPathLocker(), (MailboxACLResolver)aclResolver, (GroupMembershipResolver)groupMembershipResolver);
        manager.init();
        this.setMailboxManager((MailboxManager)manager);
        try {
            super.testList();
        }
        finally {
            try {
                this.deleteMaildirTestDirectory();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void createMailboxManager() {
    }

    private void deleteMaildirTestDirectory() throws IOException {
        FileUtils.deleteDirectory((File)new File(MAILDIR_HOME));
    }
}

