/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.james.mailbox.AbstractStressTest;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.acl.GroupMembershipResolver;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.acl.SimpleGroupMembershipResolver;
import org.apache.james.mailbox.acl.UnionMailboxACLResolver;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.maildir.MaildirMailboxSessionMapperFactory;
import org.apache.james.mailbox.maildir.MaildirStore;
import org.apache.james.mailbox.maildir.OsDetector;
import org.apache.james.mailbox.store.JVMMailboxPathLocker;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.junit.After;
import org.junit.Before;

public class MaildirStressTest
extends AbstractStressTest {
    private static final String MAILDIR_HOME = "target/Maildir";
    private StoreMailboxManager<Integer> mailboxManager;

    @Before
    public void setUp() throws MailboxException {
        MaildirStore store = new MaildirStore("target/Maildir/%user", (MailboxPathLocker)new JVMMailboxPathLocker());
        MaildirMailboxSessionMapperFactory mf = new MaildirMailboxSessionMapperFactory(store);
        UnionMailboxACLResolver aclResolver = new UnionMailboxACLResolver();
        SimpleGroupMembershipResolver groupMembershipResolver = new SimpleGroupMembershipResolver();
        this.mailboxManager = new StoreMailboxManager((MailboxSessionMapperFactory)mf, null, (MailboxPathLocker)new JVMMailboxPathLocker(), (MailboxACLResolver)aclResolver, (GroupMembershipResolver)groupMembershipResolver);
        this.mailboxManager.init();
    }

    @After
    public void tearDown() throws IOException {
        FileUtils.deleteDirectory((File)new File(MAILDIR_HOME));
    }

    public void testStessTest() throws InterruptedException, MailboxException {
        if (OsDetector.isWindows()) {
            System.out.println("Maildir tests work only on non-windows systems. So skip the test");
        } else {
            super.testStessTest();
        }
    }

    protected MailboxManager getMailboxManager() {
        return this.mailboxManager;
    }
}

