/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir;

import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.SubscriptionException;
import org.apache.james.mailbox.maildir.MaildirStore;
import org.apache.james.mailbox.maildir.mail.MaildirMailboxMapper;
import org.apache.james.mailbox.maildir.mail.MaildirMessageMapper;
import org.apache.james.mailbox.maildir.user.MaildirSubscriptionMapper;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.user.SubscriptionMapper;

public class MaildirMailboxSessionMapperFactory
extends MailboxSessionMapperFactory<Integer> {
    private final MaildirStore store;

    public MaildirMailboxSessionMapperFactory(MaildirStore store) {
        this.store = store;
    }

    protected MailboxMapper<Integer> createMailboxMapper(MailboxSession session) throws MailboxException {
        return new MaildirMailboxMapper(this.store, session);
    }

    protected MessageMapper<Integer> createMessageMapper(MailboxSession session) throws MailboxException {
        return new MaildirMessageMapper(session, this.store);
    }

    protected SubscriptionMapper createSubscriptionMapper(MailboxSession session) throws SubscriptionException {
        return new MaildirSubscriptionMapper(this.store);
    }
}

