/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir.mail;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.maildir.MaildirFolder;
import org.apache.james.mailbox.maildir.MaildirMessageName;
import org.apache.james.mailbox.maildir.MaildirStore;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailbox;
import org.apache.james.mailbox.store.transaction.NonTransactionalMapper;

public class MaildirMailboxMapper
extends NonTransactionalMapper
implements MailboxMapper<Integer> {
    private final MaildirStore maildirStore;
    private ArrayList<Mailbox<Integer>> mailboxCache = new ArrayList();
    private final MailboxSession session;

    public MaildirMailboxMapper(MaildirStore maildirStore, MailboxSession session) {
        this.maildirStore = maildirStore;
        this.session = session;
    }

    public void delete(Mailbox<Integer> mailbox) throws MailboxException {
        String folderName = this.maildirStore.getFolderName(mailbox);
        File folder = new File(folderName);
        if (folder.isDirectory()) {
            try {
                if (mailbox.getName().equals("INBOX")) {
                    FileUtils.deleteDirectory((File)new File(folder, "cur"));
                    FileUtils.deleteDirectory((File)new File(folder, "new"));
                    FileUtils.deleteDirectory((File)new File(folder, "tmp"));
                    File uidListFile = new File(folder, "james-uidlist");
                    uidListFile.delete();
                    File validityFile = new File(folder, "james-uidvalidity");
                    validityFile.delete();
                }
                FileUtils.deleteDirectory((File)folder);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new MailboxException("Unable to delete Mailbox " + mailbox, (Exception)e);
            }
        } else {
            throw new MailboxNotFoundException(mailbox.getName());
        }
    }

    public Mailbox<Integer> findMailboxByPath(MailboxPath mailboxPath) throws MailboxException, MailboxNotFoundException {
        Mailbox<Integer> mailbox = this.maildirStore.loadMailbox(this.session, mailboxPath);
        return this.cacheMailbox(mailbox);
    }

    public List<Mailbox<Integer>> findMailboxWithPathLike(MailboxPath mailboxPath) throws MailboxException {
        Pattern searchPattern = Pattern.compile("[.]" + mailboxPath.getName().replace(".", "\\.").replace("%", ".*"));
        FilenameFilter filter = MaildirMessageName.createRegexFilter(searchPattern);
        File root = this.maildirStore.getMailboxRootForUser(mailboxPath.getUser());
        File[] folders = root.listFiles(filter);
        ArrayList<Mailbox<Integer>> mailboxList = new ArrayList<Mailbox<Integer>>();
        for (File folder : folders) {
            if (!folder.isDirectory()) continue;
            Mailbox<Integer> mailbox = this.maildirStore.loadMailbox(this.session, root, mailboxPath.getNamespace(), mailboxPath.getUser(), folder.getName());
            mailboxList.add(this.cacheMailbox(mailbox));
        }
        if (Pattern.matches(mailboxPath.getName().replace("%", ".*"), "INBOX")) {
            Mailbox<Integer> mailbox = this.maildirStore.loadMailbox(this.session, root, mailboxPath.getNamespace(), mailboxPath.getUser(), "");
            mailboxList.add(0, this.cacheMailbox(mailbox));
        }
        return mailboxList;
    }

    public boolean hasChildren(Mailbox<Integer> mailbox, char delimiter) throws MailboxException, MailboxNotFoundException {
        String searchString = mailbox.getName() + "." + "%";
        List<Mailbox<Integer>> mailboxes = this.findMailboxWithPathLike(new MailboxPath(mailbox.getNamespace(), mailbox.getUser(), searchString));
        return mailboxes.size() > 0;
    }

    public void save(Mailbox<Integer> mailbox) throws MailboxException {
        block22: {
            try {
                Mailbox<Integer> originalMailbox = this.getCachedMailbox((Integer)mailbox.getMailboxId());
                MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
                if (!(originalMailbox.getName() == null ? mailbox.getName() != null : !originalMailbox.getName().equals(mailbox.getName()))) break block22;
                if (folder.exists()) {
                    throw new MailboxExistsException(mailbox.getName());
                }
                MaildirFolder originalFolder = this.maildirStore.createMaildirFolder(originalMailbox);
                if (originalMailbox.getName().equals("INBOX")) {
                    try {
                        File inboxFolder = originalFolder.getRootFile();
                        File newFolder = folder.getRootFile();
                        if (!newFolder.mkdirs()) {
                            throw new IOException("Could not create folder " + newFolder);
                        }
                        if (!originalFolder.getCurFolder().renameTo(folder.getCurFolder())) {
                            throw new IOException("Could not rename folder " + originalFolder.getCurFolder() + " to " + folder.getCurFolder());
                        }
                        if (!originalFolder.getNewFolder().renameTo(folder.getNewFolder())) {
                            throw new IOException("Could not rename folder " + originalFolder.getNewFolder() + " to " + folder.getNewFolder());
                        }
                        if (!originalFolder.getTmpFolder().renameTo(folder.getTmpFolder())) {
                            throw new IOException("Could not rename folder " + originalFolder.getTmpFolder() + " to " + folder.getTmpFolder());
                        }
                        File oldUidListFile = new File(inboxFolder, "james-uidlist");
                        File newUidListFile = new File(newFolder, "james-uidlist");
                        if (!oldUidListFile.renameTo(newUidListFile)) {
                            throw new IOException("Could not rename file " + oldUidListFile + " to " + newUidListFile);
                        }
                        File oldValidityFile = new File(inboxFolder, "james-uidvalidity");
                        File newValidityFile = new File(newFolder, "james-uidvalidity");
                        if (!oldValidityFile.renameTo(newValidityFile)) {
                            throw new IOException("Could not rename file " + oldValidityFile + " to " + newValidityFile);
                        }
                        if (!originalFolder.getCurFolder().mkdir()) {
                            throw new IOException("Could not create folder " + originalFolder.getCurFolder());
                        }
                        if (!originalFolder.getNewFolder().mkdir()) {
                            throw new IOException("Could not create folder " + originalFolder.getNewFolder());
                        }
                        if (!originalFolder.getTmpFolder().mkdir()) {
                            throw new IOException("Could not create folder " + originalFolder.getTmpFolder());
                        }
                        break block22;
                    }
                    catch (IOException e) {
                        throw new MailboxException("Failed to save Mailbox " + mailbox, (Exception)e);
                    }
                }
                if (!originalFolder.getRootFile().renameTo(folder.getRootFile())) {
                    throw new MailboxException("Failed to save Mailbox " + mailbox, (Exception)new IOException("Could not rename folder " + originalFolder));
                }
            }
            catch (MailboxNotFoundException e) {
                MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
                if (!folder.exists()) {
                    boolean success = folder.getRootFile().exists();
                    if (!success) {
                        success = folder.getRootFile().mkdirs();
                    }
                    if (!success) {
                        throw new MailboxException("Failed to save Mailbox " + mailbox);
                    }
                    success = folder.getCurFolder().mkdir();
                    success = success && folder.getNewFolder().mkdir();
                    boolean bl = success = success && folder.getTmpFolder().mkdir();
                    if (!success) {
                        throw new MailboxException("Failed to save Mailbox " + mailbox, (Exception)new IOException("Needed folder structure can not be created"));
                    }
                }
                try {
                    folder.setUidValidity(mailbox.getUidValidity());
                }
                catch (IOException ioe) {
                    throw new MailboxException("Failed to save Mailbox " + mailbox, (Exception)ioe);
                }
            }
        }
    }

    public List<Mailbox<Integer>> list() throws MailboxException {
        File[] domains;
        File maildirRoot = this.maildirStore.getMaildirRoot();
        ArrayList<Mailbox<Integer>> mailboxList = new ArrayList<Mailbox<Integer>>();
        if (this.maildirStore.getMaildirLocation().endsWith("/%fulluser")) {
            File[] users = maildirRoot.listFiles();
            this.visitUsersForMailboxList(null, users, mailboxList);
            return mailboxList;
        }
        for (File domain : domains = maildirRoot.listFiles()) {
            File[] users = domain.listFiles();
            this.visitUsersForMailboxList(domain, users, mailboxList);
        }
        return mailboxList;
    }

    public void endRequest() {
        this.mailboxCache.clear();
    }

    private Mailbox<Integer> cacheMailbox(Mailbox<Integer> mailbox) {
        this.mailboxCache.add((Mailbox<Integer>)new SimpleMailbox(mailbox));
        int id = this.mailboxCache.size() - 1;
        ((SimpleMailbox)mailbox).setMailboxId((Object)id);
        return mailbox;
    }

    private Mailbox<Integer> getCachedMailbox(Integer mailboxId) throws MailboxNotFoundException {
        if (mailboxId == null) {
            throw new MailboxNotFoundException("null");
        }
        try {
            return this.mailboxCache.get(mailboxId);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MailboxNotFoundException(String.valueOf(mailboxId));
        }
    }

    private void visitUsersForMailboxList(File domain, File[] users, List<Mailbox<Integer>> mailboxList) throws MailboxException {
        String userName = null;
        for (File user : users) {
            File[] mailboxes;
            userName = domain == null ? user.getName() : user.getName() + "@" + domain.getName();
            MailboxPath inboxMailboxPath = new MailboxPath(this.session.getPersonalSpace(), userName, "INBOX");
            mailboxList.add(this.maildirStore.loadMailbox(this.session, inboxMailboxPath));
            for (File mailbox : mailboxes = user.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().startsWith(".");
                }
            })) {
                MailboxPath mailboxPath = new MailboxPath("#private", userName, mailbox.getName().substring(1));
                mailboxList.add(this.maildirStore.loadMailbox(this.session, mailboxPath));
            }
        }
    }
}

