/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir.mail;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.mail.Flags;
import org.apache.commons.io.FileUtils;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.maildir.MaildirFolder;
import org.apache.james.mailbox.maildir.MaildirMessageName;
import org.apache.james.mailbox.maildir.MaildirStore;
import org.apache.james.mailbox.maildir.mail.model.MaildirMessage;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.SimpleMessageMetaData;
import org.apache.james.mailbox.store.mail.AbstractMessageMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMessage;

public class MaildirMessageMapper
extends AbstractMessageMapper<Integer> {
    private final MaildirStore maildirStore;
    private static final int BUF_SIZE = 2048;

    public MaildirMessageMapper(MailboxSession session, MaildirStore maildirStore) {
        super(session, (UidProvider)maildirStore, (ModSeqProvider)maildirStore);
        this.maildirStore = maildirStore;
    }

    public long countMessagesInMailbox(Mailbox<Integer> mailbox) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        File newFolder = folder.getNewFolder();
        File curFolder = folder.getCurFolder();
        File[] newFiles = newFolder.listFiles();
        File[] curFiles = curFolder.listFiles();
        if (newFiles == null || curFiles == null) {
            throw new MailboxException("Unable to count messages in Mailbox " + mailbox, (Exception)new IOException("Not a valid Maildir folder: " + this.maildirStore.getFolderName(mailbox)));
        }
        int count = newFiles.length + curFiles.length;
        return count;
    }

    public long countUnseenMessagesInMailbox(Mailbox<Integer> mailbox) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        File newFolder = folder.getNewFolder();
        File curFolder = folder.getCurFolder();
        String[] unseenMessages = curFolder.list(MaildirMessageName.FILTER_UNSEEN_MESSAGES);
        String[] newUnseenMessages = newFolder.list(MaildirMessageName.FILTER_UNSEEN_MESSAGES);
        if (newUnseenMessages == null || unseenMessages == null) {
            throw new MailboxException("Unable to count unseen messages in Mailbox " + mailbox, (Exception)new IOException("Not a valid Maildir folder: " + this.maildirStore.getFolderName(mailbox)));
        }
        int count = newUnseenMessages.length + unseenMessages.length;
        return count;
    }

    public void delete(Mailbox<Integer> mailbox, Message<Integer> message) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        try {
            folder.delete(this.mailboxSession, message.getUid());
        }
        catch (MailboxException e) {
            throw new MailboxException("Unable to delete Message " + message + " in Mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    public Iterator<Message<Integer>> findInMailbox(Mailbox<Integer> mailbox, MessageRange set, MessageMapper.FetchType fType, int max) throws MailboxException {
        List<Message<Integer>> results;
        long from = set.getUidFrom();
        long to = set.getUidTo();
        MessageRange.Type type = set.getType();
        switch (type) {
            default: {
                results = this.findMessagesInMailboxBetweenUIDs(mailbox, null, 0L, -1L, max);
                break;
            }
            case FROM: {
                results = this.findMessagesInMailboxBetweenUIDs(mailbox, null, from, -1L, max);
                break;
            }
            case ONE: {
                results = this.findMessageInMailboxWithUID(mailbox, from);
                break;
            }
            case RANGE: {
                results = this.findMessagesInMailboxBetweenUIDs(mailbox, null, from, to, max);
            }
        }
        return results.iterator();
    }

    public List<Long> findRecentMessageUidsInMailbox(Mailbox<Integer> mailbox) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        SortedMap<Long, MaildirMessageName> recentMessageNames = folder.getRecentMessages(this.mailboxSession);
        return new ArrayList<Long>(recentMessageNames.keySet());
    }

    public Long findFirstUnseenMessageUid(Mailbox<Integer> mailbox) throws MailboxException {
        List<Message<Integer>> result = this.findMessagesInMailbox(mailbox, MaildirMessageName.FILTER_UNSEEN_MESSAGES, 1);
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0).getUid();
    }

    public Iterator<UpdatedFlags> updateFlags(Mailbox<Integer> mailbox, Flags flags, boolean value, boolean replace, MessageRange set) throws MailboxException {
        ArrayList<UpdatedFlags> updatedFlags = new ArrayList<UpdatedFlags>();
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        Iterator<Message<Integer>> it = this.findInMailbox(mailbox, set, MessageMapper.FetchType.Metadata, -1);
        while (it.hasNext()) {
            Message<Integer> member = it.next();
            Flags originalFlags = member.createFlags();
            if (replace) {
                member.setFlags(flags);
            } else {
                Flags current = member.createFlags();
                if (value) {
                    current.add(flags);
                } else {
                    current.remove(flags);
                }
                member.setFlags(current);
            }
            Flags newFlags = member.createFlags();
            try {
                long modSeq;
                MaildirMessageName messageName = folder.getMessageNameByUid(this.mailboxSession, member.getUid());
                if (messageName == null) continue;
                File messageFile = messageName.getFile();
                messageName.setFlags(member.createFlags());
                String newMessageName = messageName.getFullName();
                File newMessageFile = newFlags.contains(Flags.Flag.RECENT) ? new File(folder.getNewFolder(), newMessageName) : new File(folder.getCurFolder(), newMessageName);
                if (!newMessageFile.equals(messageFile)) {
                    FileUtils.moveFile((File)messageFile, (File)newMessageFile);
                    modSeq = newMessageFile.lastModified();
                } else {
                    modSeq = messageFile.lastModified();
                }
                member.setModSeq(modSeq);
                updatedFlags.add(new UpdatedFlags(member.getUid(), modSeq, originalFlags, newFlags));
                long uid = member.getUid();
                folder.update(this.mailboxSession, uid, newMessageName);
            }
            catch (IOException e) {
                throw new MailboxException("Failure while save Message " + member + " in Mailbox " + mailbox, (Exception)e);
            }
        }
        return updatedFlags.iterator();
    }

    public Map<Long, MessageMetaData> expungeMarkedForDeletionInMailbox(Mailbox<Integer> mailbox, MessageRange set) throws MailboxException {
        List<Object> results = new ArrayList();
        long from = set.getUidFrom();
        long to = set.getUidTo();
        MessageRange.Type type = set.getType();
        switch (type) {
            default: {
                results = this.findMessagesInMailbox(mailbox, MaildirMessageName.FILTER_DELETED_MESSAGES, -1);
                break;
            }
            case FROM: {
                results = this.findMessagesInMailboxBetweenUIDs(mailbox, MaildirMessageName.FILTER_DELETED_MESSAGES, from, -1L, -1);
                break;
            }
            case ONE: {
                results = this.findDeletedMessageInMailboxWithUID(mailbox, from);
                break;
            }
            case RANGE: {
                results = this.findMessagesInMailboxBetweenUIDs(mailbox, MaildirMessageName.FILTER_DELETED_MESSAGES, from, to, -1);
            }
        }
        HashMap<Long, MessageMetaData> uids = new HashMap<Long, MessageMetaData>();
        for (int i = 0; i < results.size(); ++i) {
            Message m = (Message)results.get(i);
            long uid = m.getUid();
            uids.put(uid, (MessageMetaData)new SimpleMessageMetaData(m));
            this.delete(mailbox, (Message<Integer>)m);
        }
        return uids;
    }

    public MessageMetaData move(Mailbox<Integer> mailbox, Message<Integer> original) throws MailboxException {
        throw new UnsupportedOperationException("Not implemented - see https://issues.apache.org/jira/browse/IMAP-370");
    }

    protected MessageMetaData copy(Mailbox<Integer> mailbox, long uid, long modSeq, Message<Integer> original) throws MailboxException {
        SimpleMessage theCopy = new SimpleMessage(mailbox, original);
        Flags flags = theCopy.createFlags();
        flags.add(Flags.Flag.RECENT);
        theCopy.setFlags(flags);
        return this.save(mailbox, (Message<Integer>)theCopy);
    }

    protected MessageMetaData save(Mailbox<Integer> mailbox, Message<Integer> message) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        long uid = 0L;
        File tmpFolder = folder.getTmpFolder();
        MaildirMessageName messageName = MaildirMessageName.createUniqueName(folder, message.getFullContentOctets());
        File messageFile = new File(tmpFolder, messageName.getFullName());
        FileOutputStream fos = null;
        InputStream input = null;
        try {
            if (!messageFile.createNewFile()) {
                throw new IOException("Could not create file " + messageFile);
            }
            fos = new FileOutputStream(messageFile);
            input = message.getFullContent();
            byte[] b = new byte[2048];
            int len = 0;
            while ((len = input.read(b)) != -1) {
                fos.write(b, 0, len);
            }
        }
        catch (IOException ioe) {
            throw new MailboxException("Failure while save Message " + message + " in Mailbox " + mailbox, (Exception)ioe);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {}
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {}
        }
        File newMessageFile = null;
        if (message.isRecent()) {
            messageName.setFlags(message.createFlags());
            newMessageFile = new File(folder.getNewFolder(), messageName.getFullName());
        } else {
            messageName.setFlags(message.createFlags());
            newMessageFile = new File(folder.getCurFolder(), messageName.getFullName());
        }
        try {
            FileUtils.moveFile((File)messageFile, (File)newMessageFile);
        }
        catch (IOException e) {
            throw new MailboxException("Failure while save Message " + message + " in Mailbox " + mailbox, (Exception)e);
        }
        try {
            uid = folder.appendMessage(this.mailboxSession, newMessageFile.getName());
            message.setUid(uid);
            message.setModSeq(newMessageFile.lastModified());
            return new SimpleMessageMetaData(message);
        }
        catch (MailboxException e) {
            throw new MailboxException("Failure while save Message " + message + " in Mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    public void endRequest() {
    }

    private List<Message<Integer>> findMessageInMailboxWithUID(Mailbox<Integer> mailbox, long uid) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        try {
            MaildirMessageName messageName = folder.getMessageNameByUid(this.mailboxSession, uid);
            ArrayList<Message<Integer>> messages = new ArrayList<Message<Integer>>();
            if (messageName != null && messageName.getFile().exists()) {
                messages.add((Message<Integer>)new MaildirMessage(mailbox, uid, messageName));
            }
            return messages;
        }
        catch (IOException e) {
            throw new MailboxException("Failure while search for Message with uid " + uid + " in Mailbox " + mailbox, (Exception)e);
        }
    }

    private List<Message<Integer>> findMessagesInMailboxBetweenUIDs(Mailbox<Integer> mailbox, FilenameFilter filter, long from, long to, int max) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        int cur = 0;
        SortedMap<Long, MaildirMessageName> uidMap = null;
        try {
            uidMap = filter != null ? folder.getUidMap(this.mailboxSession, filter, from, to) : folder.getUidMap(this.mailboxSession, from, to);
            ArrayList<Message<Integer>> messages = new ArrayList<Message<Integer>>();
            for (Map.Entry<Long, MaildirMessageName> entry : uidMap.entrySet()) {
                messages.add((Message<Integer>)new MaildirMessage(mailbox, entry.getKey(), entry.getValue()));
                if (max == -1 || ++cur < max) continue;
                break;
            }
            return messages;
        }
        catch (IOException e) {
            throw new MailboxException("Failure while search for Messages in Mailbox " + mailbox, (Exception)e);
        }
    }

    private List<Message<Integer>> findMessagesInMailbox(Mailbox<Integer> mailbox, FilenameFilter filter, int limit) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        try {
            SortedMap<Long, MaildirMessageName> uidMap = folder.getUidMap(this.mailboxSession, filter, limit);
            ArrayList<Message<Integer>> filtered = new ArrayList<Message<Integer>>(uidMap.size());
            for (Map.Entry<Long, MaildirMessageName> entry : uidMap.entrySet()) {
                filtered.add((Message<Integer>)new MaildirMessage(mailbox, entry.getKey(), entry.getValue()));
            }
            return filtered;
        }
        catch (IOException e) {
            throw new MailboxException("Failure while search for Messages in Mailbox " + mailbox, (Exception)e);
        }
    }

    private List<Message<Integer>> findDeletedMessageInMailboxWithUID(Mailbox<Integer> mailbox, long uid) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        try {
            MaildirMessageName messageName = folder.getMessageNameByUid(this.mailboxSession, uid);
            ArrayList<Message<Integer>> messages = new ArrayList<Message<Integer>>();
            if (MaildirMessageName.FILTER_DELETED_MESSAGES.accept(null, messageName.getFullName())) {
                messages.add((Message<Integer>)new MaildirMessage(mailbox, uid, messageName));
            }
            return messages;
        }
        catch (IOException e) {
            throw new MailboxException("Failure while search for Messages in Mailbox " + mailbox, (Exception)e);
        }
    }

    protected void begin() throws MailboxException {
    }

    protected void commit() throws MailboxException {
    }

    protected void rollback() throws MailboxException {
    }
}

