/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir.user;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.james.mailbox.exception.SubscriptionException;
import org.apache.james.mailbox.maildir.MaildirStore;
import org.apache.james.mailbox.store.transaction.NonTransactionalMapper;
import org.apache.james.mailbox.store.user.SubscriptionMapper;
import org.apache.james.mailbox.store.user.model.Subscription;
import org.apache.james.mailbox.store.user.model.impl.SimpleSubscription;

public class MaildirSubscriptionMapper
extends NonTransactionalMapper
implements SubscriptionMapper {
    private static final String FILE_SUBSCRIPTION = "subscriptions";
    private MaildirStore store;

    public MaildirSubscriptionMapper(MaildirStore store) {
        this.store = store;
    }

    public void delete(Subscription subscription) throws SubscriptionException {
        Set<String> subscriptionNames = this.readSubscriptionsForUser(subscription.getUser());
        boolean changed = subscriptionNames.remove(subscription.getMailbox());
        if (changed) {
            try {
                this.writeSubscriptions(new File(this.store.userRoot(subscription.getUser())), subscriptionNames);
            }
            catch (IOException e) {
                throw new SubscriptionException((Exception)e);
            }
        }
    }

    public List<Subscription> findSubscriptionsForUser(String user) throws SubscriptionException {
        Set<String> subscriptionNames = this.readSubscriptionsForUser(user);
        ArrayList<Subscription> subscriptions = new ArrayList<Subscription>();
        for (String subscription : subscriptionNames) {
            subscriptions.add((Subscription)new SimpleSubscription(user, subscription));
        }
        return subscriptions;
    }

    public Subscription findMailboxSubscriptionForUser(String user, String mailbox) throws SubscriptionException {
        Set<String> subscriptionNames;
        File userRoot = new File(this.store.userRoot(user));
        try {
            subscriptionNames = this.readSubscriptions(userRoot);
        }
        catch (IOException e) {
            throw new SubscriptionException((Exception)e);
        }
        if (subscriptionNames.contains(mailbox)) {
            return new SimpleSubscription(user, mailbox);
        }
        return null;
    }

    public void save(Subscription subscription) throws SubscriptionException {
        Set<String> subscriptionNames = this.readSubscriptionsForUser(subscription.getUser());
        boolean changed = subscriptionNames.add(subscription.getMailbox());
        if (changed) {
            try {
                this.writeSubscriptions(new File(this.store.userRoot(subscription.getUser())), subscriptionNames);
            }
            catch (IOException e) {
                throw new SubscriptionException((Exception)e);
            }
        }
    }

    public void endRequest() {
    }

    private Set<String> readSubscriptionsForUser(String user) throws SubscriptionException {
        Set<String> subscriptionNames;
        File userRoot = new File(this.store.userRoot(user));
        try {
            subscriptionNames = this.readSubscriptions(userRoot);
        }
        catch (IOException e) {
            throw new SubscriptionException((Exception)e);
        }
        return subscriptionNames;
    }

    private Set<String> readSubscriptions(File mailboxFolder) throws IOException {
        String subscription;
        File subscriptionFile = new File(mailboxFolder, FILE_SUBSCRIPTION);
        HashSet<String> subscriptions = new HashSet<String>();
        if (!subscriptionFile.exists()) {
            return subscriptions;
        }
        FileReader fileReader = new FileReader(subscriptionFile);
        BufferedReader reader = new BufferedReader(fileReader);
        while ((subscription = reader.readLine()) != null) {
            if (subscription.equals("")) continue;
            subscriptions.add(subscription);
        }
        reader.close();
        fileReader.close();
        return subscriptions;
    }

    private void writeSubscriptions(File mailboxFolder, Set<String> subscriptions) throws IOException {
        ArrayList<String> sortedSubscriptions = new ArrayList<String>(subscriptions);
        Collections.sort(sortedSubscriptions);
        if (!mailboxFolder.exists() && !mailboxFolder.mkdirs()) {
            throw new IOException("Could not create folder " + mailboxFolder);
        }
        File subscriptionFile = new File(mailboxFolder, FILE_SUBSCRIPTION);
        if (!subscriptionFile.exists() && !subscriptionFile.createNewFile()) {
            throw new IOException("Could not create file " + subscriptionFile);
        }
        FileWriter fileWriter = new FileWriter(subscriptionFile);
        PrintWriter writer = new PrintWriter(fileWriter);
        for (String subscription : sortedSubscriptions) {
            writer.println(subscription);
        }
        writer.close();
        fileWriter.close();
    }
}

