/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.mailing.commands;

import java.time.Instant;
import java.util.Objects;
import org.apache.james.core.User;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.eventsourcing.Command;
import org.apache.james.mailbox.model.Quota;

public class DetectThresholdCrossing
implements Command {
    private final User user;
    private final Quota<QuotaCount> countQuota;
    private final Quota<QuotaSize> sizeQuota;
    private final Instant instant;

    public DetectThresholdCrossing(User user, Quota<QuotaCount> countQuota, Quota<QuotaSize> sizeQuota, Instant instant) {
        this.user = user;
        this.countQuota = countQuota;
        this.sizeQuota = sizeQuota;
        this.instant = instant;
    }

    public User getUser() {
        return this.user;
    }

    public Quota<QuotaCount> getCountQuota() {
        return this.countQuota;
    }

    public Quota<QuotaSize> getSizeQuota() {
        return this.sizeQuota;
    }

    public Instant getInstant() {
        return this.instant;
    }

    public final boolean equals(Object o) {
        if (o instanceof DetectThresholdCrossing) {
            DetectThresholdCrossing that = (DetectThresholdCrossing)o;
            return Objects.equals(this.user, that.user) && Objects.equals(this.countQuota, that.countQuota) && Objects.equals(this.sizeQuota, that.sizeQuota);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.user, this.countQuota, this.sizeQuota);
    }
}

