/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.mailing.commands;

import java.util.List;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.CommandHandler;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.mailbox.quota.mailing.QuotaMailingListenerConfiguration;
import org.apache.james.mailbox.quota.mailing.aggregates.UserQuotaThresholds;
import org.apache.james.mailbox.quota.mailing.commands.DetectThresholdCrossing;

public class DetectThresholdCrossingHandler
implements CommandHandler<DetectThresholdCrossing> {
    private final EventStore eventStore;
    private final QuotaMailingListenerConfiguration quotaMailingListenerConfiguration;
    private final String listenerName;

    public DetectThresholdCrossingHandler(EventStore eventStore, QuotaMailingListenerConfiguration quotaMailingListenerConfiguration) {
        this.eventStore = eventStore;
        this.quotaMailingListenerConfiguration = quotaMailingListenerConfiguration;
        this.listenerName = quotaMailingListenerConfiguration.getName();
    }

    public List<? extends Event> handle(DetectThresholdCrossing command) {
        return this.loadAggregate(command).detectThresholdCrossing(this.quotaMailingListenerConfiguration, command);
    }

    private UserQuotaThresholds loadAggregate(DetectThresholdCrossing command) {
        UserQuotaThresholds.Id aggregateId = UserQuotaThresholds.Id.from(command.getUser(), this.listenerName);
        History history = this.eventStore.getEventsOfAggregate((AggregateId)aggregateId);
        return UserQuotaThresholds.fromEvents(aggregateId, history);
    }

    public Class<DetectThresholdCrossing> handledClass() {
        return DetectThresholdCrossing.class;
    }
}

