/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.mailing.events;

import java.util.Objects;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.quota.mailing.aggregates.UserQuotaThresholds;
import org.apache.james.mailbox.quota.model.HistoryEvolution;

public class QuotaThresholdChangedEvent
implements Event {
    private final EventId eventId;
    private final HistoryEvolution sizeHistoryEvolution;
    private final HistoryEvolution countHistoryEvolution;
    private final Quota<QuotaSize> sizeQuota;
    private final Quota<QuotaCount> countQuota;
    private final UserQuotaThresholds.Id aggregateId;

    public QuotaThresholdChangedEvent(EventId eventId, HistoryEvolution sizeHistoryEvolution, HistoryEvolution countHistoryEvolution, Quota<QuotaSize> sizeQuota, Quota<QuotaCount> countQuota, UserQuotaThresholds.Id aggregateId) {
        this.eventId = eventId;
        this.sizeHistoryEvolution = sizeHistoryEvolution;
        this.countHistoryEvolution = countHistoryEvolution;
        this.sizeQuota = sizeQuota;
        this.countQuota = countQuota;
        this.aggregateId = aggregateId;
    }

    public HistoryEvolution getSizeHistoryEvolution() {
        return this.sizeHistoryEvolution;
    }

    public HistoryEvolution getCountHistoryEvolution() {
        return this.countHistoryEvolution;
    }

    public Quota<QuotaSize> getSizeQuota() {
        return this.sizeQuota;
    }

    public Quota<QuotaCount> getCountQuota() {
        return this.countQuota;
    }

    public EventId eventId() {
        return this.eventId;
    }

    public UserQuotaThresholds.Id getAggregateId() {
        return this.aggregateId;
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaThresholdChangedEvent) {
            QuotaThresholdChangedEvent that = (QuotaThresholdChangedEvent)o;
            return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.sizeHistoryEvolution, that.sizeHistoryEvolution) && Objects.equals(this.countHistoryEvolution, that.countHistoryEvolution) && Objects.equals(this.sizeQuota, that.sizeQuota) && Objects.equals(this.countQuota, that.countQuota) && Objects.equals(this.aggregateId, that.aggregateId);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.eventId, this.sizeHistoryEvolution, this.countHistoryEvolution, this.sizeQuota, this.countQuota, this.aggregateId);
    }
}

