/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.mailing.listeners;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.core.User;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.eventsourcing.Command;
import org.apache.james.eventsourcing.EventSourcingSystem;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.mailbox.events.Event;
import org.apache.james.mailbox.events.Group;
import org.apache.james.mailbox.events.MailboxListener;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.quota.mailing.QuotaMailingListenerConfiguration;
import org.apache.james.mailbox.quota.mailing.commands.DetectThresholdCrossing;
import org.apache.james.mailbox.quota.mailing.commands.DetectThresholdCrossingHandler;
import org.apache.james.mailbox.quota.mailing.subscribers.QuotaThresholdMailer;
import org.apache.james.user.api.UsersRepository;
import org.apache.mailet.MailetContext;

public class QuotaThresholdCrossingListener
implements MailboxListener.GroupMailboxListener {
    private static final Group GROUP = new QuotaThresholdCrossingListenerGroup();
    private final EventSourcingSystem eventSourcingSystem;

    @Inject
    public QuotaThresholdCrossingListener(MailetContext mailetContext, UsersRepository usersRepository, FileSystem fileSystem, EventStore eventStore, HierarchicalConfiguration config) {
        this(mailetContext, usersRepository, fileSystem, eventStore, QuotaMailingListenerConfiguration.from(config));
    }

    public QuotaThresholdCrossingListener(MailetContext mailetContext, UsersRepository usersRepository, FileSystem fileSystem, EventStore eventStore, QuotaMailingListenerConfiguration config) {
        ImmutableSet handlers = ImmutableSet.of((Object)new DetectThresholdCrossingHandler(eventStore, config));
        ImmutableSet subscribers = ImmutableSet.of((Object)new QuotaThresholdMailer(mailetContext, usersRepository, fileSystem, config));
        this.eventSourcingSystem = new EventSourcingSystem((Set)handlers, (Set)subscribers, eventStore);
    }

    public Group getDefaultGroup() {
        return GROUP;
    }

    public void event(Event event) {
        if (event instanceof MailboxListener.QuotaUsageUpdatedEvent) {
            this.handleEvent(event.getUser(), (MailboxListener.QuotaUsageUpdatedEvent)event);
        }
    }

    private void handleEvent(User user, MailboxListener.QuotaUsageUpdatedEvent event) {
        this.eventSourcingSystem.dispatch((Command)new DetectThresholdCrossing(user, (Quota<QuotaCount>)event.getCountQuota(), (Quota<QuotaSize>)event.getSizeQuota(), event.getInstant()));
    }

    private static class QuotaThresholdCrossingListenerGroup
    extends Group {
        private QuotaThresholdCrossingListenerGroup() {
        }
    }
}

