/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.mailing.subscribers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.StringReader;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.quota.mailing.QuotaMailingListenerConfiguration;
import org.apache.james.mailbox.quota.model.HistoryEvolution;
import org.apache.james.mailbox.quota.model.QuotaThreshold;
import org.apache.james.mailbox.quota.model.QuotaThresholdChange;
import org.apache.james.util.OptionalUtils;
import org.apache.james.util.SizeFormat;

public class QuotaThresholdNotice {
    private final Optional<QuotaThreshold> countThreshold;
    private final Optional<QuotaThreshold> sizeThreshold;
    private final Quota<QuotaSize> sizeQuota;
    private final Quota<QuotaCount> countQuota;
    private final QuotaMailingListenerConfiguration configuration;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    QuotaThresholdNotice(Optional<QuotaThreshold> countThreshold, Optional<QuotaThreshold> sizeThreshold, Quota<QuotaSize> sizeQuota, Quota<QuotaCount> countQuota, QuotaMailingListenerConfiguration configuration) {
        this.countThreshold = countThreshold;
        this.sizeThreshold = sizeThreshold;
        this.sizeQuota = sizeQuota;
        this.countQuota = countQuota;
        this.configuration = configuration;
    }

    public MimeMessageBuilder generateMimeMessage(FileSystem fileSystem) throws IOException {
        return MimeMessageBuilder.mimeMessageBuilder().setSubject(this.generateSubject(fileSystem)).setText(this.generateReport(fileSystem));
    }

    @VisibleForTesting
    String generateSubject(FileSystem fileSystem) throws IOException {
        return this.renderTemplate(fileSystem, this.configuration.getSubjectTemplate(this.mostSignificantThreshold()));
    }

    @VisibleForTesting
    String generateReport(FileSystem fileSystem) throws IOException {
        return this.renderTemplate(fileSystem, this.configuration.getBodyTemplate(this.mostSignificantThreshold()));
    }

    private QuotaThreshold mostSignificantThreshold() {
        return (QuotaThreshold)Stream.of(this.countThreshold, this.sizeThreshold).flatMap(OptionalUtils::toStream).min(Comparator.reverseOrder()).get();
    }

    /*
     * Exception decompiling
     */
    private String renderTemplate(FileSystem fileSystem, String template) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private StringReader getPatternReader(FileSystem fileSystem, String path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HashMap<String, Object> computeScopes() {
        HashMap<String, Object> scopes = new HashMap<String, Object>();
        scopes.put("hasExceededSizeThreshold", this.sizeThreshold.isPresent());
        scopes.put("hasExceededCountThreshold", this.countThreshold.isPresent());
        this.sizeThreshold.ifPresent(value -> scopes.put("sizeThreshold", value.getQuotaOccupationRatioAsPercent()));
        this.countThreshold.ifPresent(value -> scopes.put("countThreshold", value.getQuotaOccupationRatioAsPercent()));
        scopes.put("usedSize", SizeFormat.format((long)((QuotaSize)this.sizeQuota.getUsed()).asLong()));
        scopes.put("hasSizeLimit", ((QuotaSize)this.sizeQuota.getLimit()).isLimited());
        if (((QuotaSize)this.sizeQuota.getLimit()).isLimited()) {
            scopes.put("limitSize", SizeFormat.format((long)((QuotaSize)this.sizeQuota.getLimit()).asLong()));
        }
        scopes.put("usedCount", ((QuotaCount)this.countQuota.getUsed()).asLong());
        scopes.put("hasCountLimit", ((QuotaCount)this.countQuota.getLimit()).isLimited());
        if (((QuotaCount)this.countQuota.getLimit()).isLimited()) {
            scopes.put("limitCount", ((QuotaSize)this.sizeQuota.getLimit()).asLong());
        }
        return scopes;
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaThresholdNotice) {
            QuotaThresholdNotice that = (QuotaThresholdNotice)o;
            return Objects.equals(this.countThreshold, that.countThreshold) && Objects.equals(this.sizeThreshold, that.sizeThreshold) && Objects.equals(this.sizeQuota, that.sizeQuota) && Objects.equals(this.countQuota, that.countQuota) && Objects.equals(this.configuration, that.configuration);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.countThreshold, this.sizeThreshold, this.sizeQuota, this.countQuota, this.configuration);
    }

    public static class Builder {
        private Optional<QuotaThreshold> countThreshold = Optional.empty();
        private Optional<QuotaThreshold> sizeThreshold = Optional.empty();
        private Quota<QuotaSize> sizeQuota;
        private Quota<QuotaCount> countQuota;
        private QuotaMailingListenerConfiguration configuration;

        public Builder sizeQuota(Quota<QuotaSize> sizeQuota) {
            this.sizeQuota = sizeQuota;
            return this;
        }

        public Builder countQuota(Quota<QuotaCount> countQuota) {
            this.countQuota = countQuota;
            return this;
        }

        public Builder countThreshold(HistoryEvolution countHistoryEvolution) {
            this.countThreshold = Optional.of(countHistoryEvolution).filter(this::needsNotification).flatMap(HistoryEvolution::getThresholdChange).map(QuotaThresholdChange::getQuotaThreshold);
            return this;
        }

        public Builder sizeThreshold(HistoryEvolution sizeHistoryEvolution) {
            this.sizeThreshold = Optional.of(sizeHistoryEvolution).filter(this::needsNotification).flatMap(HistoryEvolution::getThresholdChange).map(QuotaThresholdChange::getQuotaThreshold);
            return this;
        }

        public Builder withConfiguration(QuotaMailingListenerConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        boolean needsNotification(HistoryEvolution evolution) {
            return evolution.getThresholdHistoryChange() == HistoryEvolution.HistoryChangeType.HigherThresholdReached && evolution.currentThresholdNotRecentlyReached();
        }

        public Optional<QuotaThresholdNotice> build() {
            Preconditions.checkNotNull((Object)this.configuration);
            Preconditions.checkNotNull(this.sizeQuota);
            Preconditions.checkNotNull((Object)this.configuration);
            if (this.sizeThreshold.isPresent() || this.countThreshold.isPresent()) {
                return Optional.of(new QuotaThresholdNotice(this.countThreshold, this.sizeThreshold, this.sizeQuota, this.countQuota, this.configuration));
            }
            return Optional.empty();
        }
    }
}

