/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.objectstorage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.blob.objectstorage.ContainerName;
import org.apache.james.blob.objectstorage.PayloadCodec;
import org.apache.james.blob.objectstorage.swift.SwiftKeystone2ObjectStorage;
import org.apache.james.blob.objectstorage.swift.SwiftKeystone3ObjectStorage;
import org.apache.james.blob.objectstorage.swift.SwiftTempAuthObjectStorage;
import org.apache.james.modules.objectstorage.PayloadCodecFactory;
import org.apache.james.modules.objectstorage.SwiftKeystone2ConfigurationReader;
import org.apache.james.modules.objectstorage.SwiftKeystone3ConfigurationReader;
import org.apache.james.modules.objectstorage.SwiftTmpAuthConfigurationReader;

public class ObjectStorageBlobConfiguration {
    private static final String OBJECTSTORAGE_CONFIGURATION_NAME = "blobstore";
    private static final String OBJECTSTORAGE_NAMESPACE = "objectstorage.namespace";
    private static final String OBJECTSTORAGE_PROVIDER = "objectstorage.provider";
    private static final String OBJECTSTORAGE_SWIFT_AUTH_API = "objectstorage.swift.authapi";
    private static final String OBJECTSTORAGE_PAYLOAD_CODEC = "objectstorage.payload.codec";
    public static final String OBJECTSTORAGE_AES256_HEXSALT = "objectstorage.aes256.hexsalt";
    public static final String OBJECTSTORAGE_AES256_PASSWORD = "objectstorage.aes256.password";
    private final PayloadCodecFactory payloadCodec;
    private final String authApi;
    private final ContainerName namespace;
    private final String provider;
    private final Optional<SwiftTempAuthObjectStorage.Configuration> tempAuth;
    private final Optional<SwiftKeystone2ObjectStorage.Configuration> keystone2Configuration;
    private final Optional<SwiftKeystone3ObjectStorage.Configuration> keystone3Configuration;
    private Optional<String> aesSalt;
    private Optional<char[]> aesPassword;

    public static ObjectStorageBlobConfiguration from(Configuration configuration) throws ConfigurationException {
        String provider = configuration.getString(OBJECTSTORAGE_PROVIDER, null);
        String namespace = configuration.getString(OBJECTSTORAGE_NAMESPACE, null);
        String authApi = configuration.getString(OBJECTSTORAGE_SWIFT_AUTH_API, null);
        String codecName = configuration.getString(OBJECTSTORAGE_PAYLOAD_CODEC, null);
        Optional<String> aesSalt = Optional.ofNullable(configuration.getString(OBJECTSTORAGE_AES256_HEXSALT, null));
        Optional<char[]> aesPassword = Optional.ofNullable(configuration.getString(OBJECTSTORAGE_AES256_PASSWORD, null)).map(String::toCharArray);
        if (Strings.isNullOrEmpty((String)provider)) {
            throw new ConfigurationException("Mandatory configuration value objectstorage.provider is missing from blobstore configuration");
        }
        if (Strings.isNullOrEmpty((String)authApi)) {
            throw new ConfigurationException("Mandatory configuration value objectstorage.swift.authapi is missing from blobstore configuration");
        }
        if (Strings.isNullOrEmpty((String)namespace)) {
            throw new ConfigurationException("Mandatory configuration value objectstorage.namespace is missing from blobstore configuration");
        }
        if (Strings.isNullOrEmpty((String)codecName)) {
            throw new ConfigurationException("Mandatory configuration value objectstorage.payload.codec is missing from blobstore configuration");
        }
        PayloadCodecFactory payloadCodecFactory = Arrays.stream(PayloadCodecFactory.values()).filter(name -> name.name().equals(codecName)).findAny().orElseThrow(() -> new ConfigurationException("unknown payload codec : " + codecName));
        Builder.RequireAuthConfiguration requireAuthConfiguration = ObjectStorageBlobConfiguration.builder().codec(payloadCodecFactory).swift().container(ContainerName.of((String)namespace));
        return ObjectStorageBlobConfiguration.defineAuthApi(configuration, authApi, requireAuthConfiguration).aesSalt(aesSalt).aesPassword(aesPassword).build();
    }

    private static Builder.ReadyToBuild defineAuthApi(Configuration configuration, String authApi, Builder.RequireAuthConfiguration requireAuthConfiguration) {
        switch (authApi) {
            case "tmpauth": {
                return requireAuthConfiguration.tempAuth(SwiftTmpAuthConfigurationReader.readSwiftConfiguration(configuration));
            }
            case "keystone2": {
                return requireAuthConfiguration.keystone2(SwiftKeystone2ConfigurationReader.readSwiftConfiguration(configuration));
            }
            case "keystone3": {
                return requireAuthConfiguration.keystone3(SwiftKeystone3ConfigurationReader.readSwiftConfiguration(configuration));
            }
        }
        throw new IllegalStateException("unexpected auth api " + authApi);
    }

    public static Builder.RequirePayloadCodec builder() {
        return payloadCodec -> () -> container -> new Builder.RequireAuthConfiguration(payloadCodec, "swift", container);
    }

    @VisibleForTesting
    ObjectStorageBlobConfiguration(PayloadCodecFactory payloadCodec, String provider, ContainerName namespace, Optional<String> aesSalt, Optional<char[]> aesPassword, String authApi, Optional<SwiftTempAuthObjectStorage.Configuration> tempAuth, Optional<SwiftKeystone2ObjectStorage.Configuration> keystone2Configuration, Optional<SwiftKeystone3ObjectStorage.Configuration> keystone3Configuration) {
        this.payloadCodec = payloadCodec;
        this.aesSalt = aesSalt;
        this.aesPassword = aesPassword;
        this.authApi = authApi;
        this.namespace = namespace;
        this.provider = provider;
        this.tempAuth = tempAuth;
        this.keystone2Configuration = keystone2Configuration;
        this.keystone3Configuration = keystone3Configuration;
    }

    public String getAuthApi() {
        return this.authApi;
    }

    public ContainerName getNamespace() {
        return this.namespace;
    }

    public String getProvider() {
        return this.provider;
    }

    public Optional<SwiftTempAuthObjectStorage.Configuration> getTempAuthConfiguration() {
        return this.tempAuth;
    }

    public Optional<SwiftKeystone2ObjectStorage.Configuration> getKeystone2Configuration() {
        return this.keystone2Configuration;
    }

    public Optional<SwiftKeystone3ObjectStorage.Configuration> getKeystone3Configuration() {
        return this.keystone3Configuration;
    }

    public PayloadCodecFactory getPayloadCodecFactory() {
        return this.payloadCodec;
    }

    public PayloadCodec getPayloadCodec() {
        return this.payloadCodec.create(this);
    }

    public Optional<String> getAesSalt() {
        return this.aesSalt;
    }

    public Optional<char[]> getAesPassword() {
        return this.aesPassword;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectStorageBlobConfiguration that = (ObjectStorageBlobConfiguration)o;
        return Objects.equals((Object)this.payloadCodec, (Object)that.payloadCodec) && Objects.equals(this.authApi, that.authApi) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.provider, that.provider) && Objects.equals(this.tempAuth, that.tempAuth) && Objects.equals(this.keystone2Configuration, that.keystone2Configuration) && Objects.equals(this.keystone3Configuration, that.keystone3Configuration) && Objects.equals(this.aesSalt, that.aesSalt) && Objects.equals(this.aesPassword, that.aesPassword);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.payloadCodec, this.authApi, this.namespace, this.provider, this.tempAuth, this.keystone2Configuration, this.keystone3Configuration, this.aesSalt, this.aesPassword});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("payloadCodec", (Object)this.payloadCodec).add("authApi", (Object)this.authApi).add("namespace", (Object)this.namespace).add("provider", (Object)this.provider).add("tempAuth", this.tempAuth).add("keystone2Configuration", this.keystone2Configuration).add("keystone3Configuration", this.keystone3Configuration).add("aesSalt", this.aesSalt).add("aesPassword", this.aesPassword).toString();
    }

    public static interface Builder {

        public static class ReadyToBuild {
            private final PayloadCodecFactory payloadCodecFactory;
            private final String provider;
            private final ContainerName container;
            private final String authApiName;
            private final Optional<SwiftTempAuthObjectStorage.Configuration> tempAuth;
            private final Optional<SwiftKeystone2ObjectStorage.Configuration> keystone2Configuration;
            private final Optional<SwiftKeystone3ObjectStorage.Configuration> keystone3Configuration;
            private Optional<String> aesSalt = Optional.empty();
            private Optional<char[]> aesPassword = Optional.empty();

            public ReadyToBuild(PayloadCodecFactory payloadCodecFactory, String provider, ContainerName container, String authApiName, Optional<SwiftTempAuthObjectStorage.Configuration> tempAuth, Optional<SwiftKeystone2ObjectStorage.Configuration> keystone2Configuration, Optional<SwiftKeystone3ObjectStorage.Configuration> keystone3Configuration) {
                this.payloadCodecFactory = payloadCodecFactory;
                this.provider = provider;
                this.container = container;
                this.authApiName = authApiName;
                this.tempAuth = tempAuth;
                this.keystone2Configuration = keystone2Configuration;
                this.keystone3Configuration = keystone3Configuration;
            }

            public ReadyToBuild aesSalt(String aesSalt) {
                return this.aesSalt(Optional.of(aesSalt));
            }

            public ReadyToBuild aesSalt(Optional<String> aesSalt) {
                this.aesSalt = aesSalt;
                return this;
            }

            public ReadyToBuild aesPassword(char[] aesPassword) {
                return this.aesPassword(Optional.of(aesPassword));
            }

            public ReadyToBuild aesPassword(Optional<char[]> aesPassword) {
                this.aesPassword = aesPassword;
                return this;
            }

            public ObjectStorageBlobConfiguration build() {
                if (this.payloadCodecFactory == PayloadCodecFactory.AES256) {
                    this.aesSalt.filter(s -> !s.isEmpty()).orElseThrow(() -> new IllegalStateException("AES code requires an non-empty salt parameter"));
                    this.aesPassword.filter(s -> ((char[])s).length > 0).orElseThrow(() -> new IllegalStateException("AES code requires an non-empty password parameter"));
                }
                return new ObjectStorageBlobConfiguration(this.payloadCodecFactory, this.provider, this.container, this.aesSalt, this.aesPassword, this.authApiName, this.tempAuth, this.keystone2Configuration, this.keystone3Configuration);
            }
        }

        public static class RequireAuthConfiguration {
            private final PayloadCodecFactory payloadCodec;
            private final String provider;
            private final ContainerName container;

            private RequireAuthConfiguration(PayloadCodecFactory payloadCodec, String provider, ContainerName container) {
                this.payloadCodec = payloadCodec;
                this.provider = provider;
                this.container = container;
            }

            public ReadyToBuild tempAuth(SwiftTempAuthObjectStorage.Configuration authConfig) {
                return new ReadyToBuild(this.payloadCodec, this.provider, this.container, "tmpauth", Optional.of(authConfig), Optional.empty(), Optional.empty());
            }

            public ReadyToBuild keystone2(SwiftKeystone2ObjectStorage.Configuration authConfig) {
                return new ReadyToBuild(this.payloadCodec, this.provider, this.container, "keystone2", Optional.empty(), Optional.of(authConfig), Optional.empty());
            }

            public ReadyToBuild keystone3(SwiftKeystone3ObjectStorage.Configuration authConfig) {
                return new ReadyToBuild(this.payloadCodec, this.provider, this.container, "keystone3", Optional.empty(), Optional.empty(), Optional.of(authConfig));
            }
        }

        @FunctionalInterface
        public static interface RequireContainerName {
            public RequireAuthConfiguration container(ContainerName var1);
        }

        @FunctionalInterface
        public static interface RequireProvider {
            public RequireContainerName swift();
        }

        @FunctionalInterface
        public static interface RequirePayloadCodec {
            public RequireProvider codec(PayloadCodecFactory var1);
        }
    }
}

