/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.objectstorage;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import java.io.FileNotFoundException;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.inject.Singleton;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.HashBlobId;
import org.apache.james.blob.objectstorage.ObjectStorageBlobsDAO;
import org.apache.james.blob.objectstorage.ObjectStorageBlobsDAOBuilder;
import org.apache.james.blob.objectstorage.swift.SwiftKeystone2ObjectStorage;
import org.apache.james.blob.objectstorage.swift.SwiftKeystone3ObjectStorage;
import org.apache.james.blob.objectstorage.swift.SwiftTempAuthObjectStorage;
import org.apache.james.modules.objectstorage.ObjectStorageBlobConfiguration;
import org.apache.james.utils.PropertiesProvider;

public class ObjectStorageDependenciesModule
extends AbstractModule {
    private static final String OBJECTSTORAGE_PROVIDER_SWIFT = "swift";

    protected void configure() {
        this.bind(BlobId.Factory.class).to(HashBlobId.Factory.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    private ObjectStorageBlobConfiguration getObjectStorageConfiguration(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            Configuration configuration = propertiesProvider.getConfiguration("blobstore");
            return ObjectStorageBlobConfiguration.from(configuration);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("blobstore configuration was not found");
        }
    }

    @Provides
    @Singleton
    private ObjectStorageBlobsDAO buildObjectStore(ObjectStorageBlobConfiguration configuration, BlobId.Factory blobIdFactory) throws InterruptedException, ExecutionException, TimeoutException {
        ObjectStorageBlobsDAO dao = this.selectDaoBuilder(configuration).container(configuration.getNamespace()).blobIdFactory(blobIdFactory).payloadCodec(configuration.getPayloadCodec()).build();
        dao.createContainer(configuration.getNamespace()).block(Duration.ofMinutes(1L));
        return dao;
    }

    private ObjectStorageBlobsDAOBuilder.RequireContainerName selectDaoBuilder(ObjectStorageBlobConfiguration configuration) {
        if (!configuration.getProvider().equals(OBJECTSTORAGE_PROVIDER_SWIFT)) {
            throw new IllegalArgumentException("unknown provider " + configuration.getProvider());
        }
        switch (configuration.getAuthApi()) {
            case "tmpauth": {
                return ObjectStorageBlobsDAO.builder((SwiftTempAuthObjectStorage.Configuration)configuration.getTempAuthConfiguration().get());
            }
            case "keystone2": {
                return ObjectStorageBlobsDAO.builder((SwiftKeystone2ObjectStorage.Configuration)configuration.getKeystone2Configuration().get());
            }
            case "keystone3": {
                return ObjectStorageBlobsDAO.builder((SwiftKeystone3ObjectStorage.Configuration)configuration.getKeystone3Configuration().get());
            }
        }
        throw new IllegalArgumentException("unknown auth api " + configuration.getAuthApi());
    }
}

