/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.objectstorage;

import org.apache.james.blob.objectstorage.AESPayloadCodec;
import org.apache.james.blob.objectstorage.DefaultPayloadCodec;
import org.apache.james.blob.objectstorage.PayloadCodec;
import org.apache.james.blob.objectstorage.crypto.CryptoConfig;
import org.apache.james.modules.objectstorage.ObjectStorageBlobConfiguration;

public enum PayloadCodecFactory {
    DEFAULT{

        @Override
        public PayloadCodec create(ObjectStorageBlobConfiguration configuration) {
            return new DefaultPayloadCodec();
        }
    }
    ,
    AES256{

        @Override
        public PayloadCodec create(ObjectStorageBlobConfiguration configuration) {
            return new AESPayloadCodec(new CryptoConfig(configuration.getAesSalt().get(), configuration.getAesPassword().get()));
        }
    };


    public abstract PayloadCodec create(ObjectStorageBlobConfiguration var1);
}

